/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.model;

import artifacts.client.item.ArtifactLayers;
import artifacts.client.item.RendererUtil;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class BeltModel
extends HumanoidModel<LivingEntity> {
    protected final ModelPart charm;
    private final float xOffset;
    private final float zOffset;
    private final float rotation;

    public BeltModel(ModelPart part, Function<ResourceLocation, RenderType> renderType, float xOffset, float zOffset, float rotation) {
        super(part, renderType);
        this.charm = this.body.getChild("charm");
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.rotation = rotation;
    }

    public BeltModel(ModelPart part, float xOffset, float zOffset, float rotation) {
        this(part, RenderType::entityCutoutNoCull, xOffset, zOffset, rotation);
    }

    public void setCharmPosition(int slot) {
        float xOffset = slot % 2 == 0 ? this.xOffset : -this.xOffset;
        float zOffset = slot % 4 < 2 ? this.zOffset : -this.zOffset;
        this.charm.setPos(xOffset, 9.0f, zOffset);
        float rotation = slot % 4 < 2 ? 0.0f : (float)(-Math.PI);
        this.charm.yRot = rotation += slot % 2 == 0 ^ slot % 4 >= 2 ? this.rotation : -this.rotation;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public static BeltModel createCloudInABottleModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.CLOUD_IN_A_BOTTLE), RenderType::entityTranslucent, 3.0f, -3.0f, -0.5f){
            private final ModelPart cloud;
            {
                this.cloud = this.charm.getChild("cloud");
            }

            public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.cloud.yRot = ageInTicks / 50.0f;
                this.cloud.y = Mth.cos((float)(ageInTicks / 30.0f)) / 2.0f;
            }
        };
    }

    public static HumanoidModel<LivingEntity> createHeliumFlamingoModel() {
        ModelPart part = RendererUtil.bakeLayer(ArtifactLayers.HELIUM_FLAMINGO);
        return new HumanoidModel<LivingEntity>(part, RenderType::entityCutoutNoCull){

            protected Iterable<ModelPart> headParts() {
                return ImmutableList.of();
            }

            protected Iterable<ModelPart> bodyParts() {
                return ImmutableList.of((Object)this.body);
            }
        };
    }

    public static BeltModel createObsidianSkullModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.OBSIDIAN_SKULL), 4.5f, -4.0f, -0.5f);
    }

    public static BeltModel createAntidoteVesselModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.ANTIDOTE_VESSEL), 4.0f, -3.0f, -0.5f);
    }

    public static BeltModel createUniversalAttractorModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.UNIVERSAL_ATTRACTOR), 2.5f, -3.0f, 0.0f);
    }

    public static BeltModel createCrystalHeartModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.CRYSTAL_HEART), RenderType::entityTranslucent, 2.5f, -3.01f, 0.0f);
    }

    public static BeltModel createChorusTotemModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.CHORUS_TOTEM), 4.0f, -3.0f, -0.5f);
    }

    public static BeltModel createWarpDriveModel() {
        return new BeltModel(RendererUtil.bakeLayer(ArtifactLayers.WARP_DRIVE), 3.5f, -3.0f, -0.3f);
    }

    private static MeshDefinition createBelt(CubeListBuilder charm) {
        CubeDeformation deformation = new CubeDeformation(0.5f);
        MeshDefinition mesh = BeltModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.ZERO);
        mesh.getRoot().getChild("body").addOrReplaceChild("charm", charm, PartPose.ZERO);
        return mesh;
    }

    public static MeshDefinition createAntidoteVessel() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f);
        charm.texOffs(0, 26);
        charm.addBox(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createCloudInABottle() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f);
        charm.texOffs(0, 25);
        charm.addBox(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f);
        MeshDefinition mesh = BeltModel.createBelt(charm);
        mesh.getRoot().getChild("body").getChild("charm").addOrReplaceChild("cloud", CubeListBuilder.create().texOffs(8, 25).addBox(-1.0f, 1.5f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        return mesh;
    }

    public static MeshDefinition createCrystalHeart() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-2.5f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f);
        charm.texOffs(6, 16);
        charm.addBox(0.5f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f);
        charm.texOffs(0, 20);
        charm.addBox(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f);
        charm.texOffs(4, 20);
        charm.addBox(-1.5f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        charm.texOffs(8, 20);
        charm.addBox(0.5f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createHeliumFlamingo() {
        MeshDefinition mesh = BeltModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 36).addBox(-1.0f, 1.0f, -14.0f, 2.0f, 3.0f, 5.0f).texOffs(0, 18).addBox(4.0f, 9.0f, -7.0f, 4.0f, 4.0f, 14.0f).texOffs(0, 0).addBox(-8.0f, 9.0f, -7.0f, 4.0f, 4.0f, 14.0f).texOffs(36, 0).addBox(-4.0f, 9.0f, 3.0f, 8.0f, 4.0f, 4.0f).texOffs(36, 8).addBox(-4.0f, 9.0f, -7.0f, 8.0f, 4.0f, 4.0f).texOffs(0, 36).addBox(-2.0f, 1.0f, -9.0f, 4.0f, 11.0f, 4.0f), PartPose.ZERO);
        return mesh;
    }

    public static MeshDefinition createObsidianSkull() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 4.0f);
        charm.texOffs(18, 16);
        charm.addBox(-1.5f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f);
        charm.texOffs(18, 19);
        charm.addBox(0.5f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createUniversalAttractor() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 1.0f);
        charm.texOffs(0, 19);
        charm.addBox(-2.5f, 2.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        charm.texOffs(6, 19);
        charm.addBox(0.5f, 2.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createChorusTotem() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-1.5f, -1.0f, -1.0f, 3.0f, 7.0f, 2.0f);
        charm.texOffs(10, 16);
        charm.addBox(-3.5f, 0.0f, 1.0f, 7.0f, 4.0f, 0.0f);
        charm.texOffs(0, 25);
        charm.addBox(-2.5f, 3.0f, -2.0f, 5.0f, 2.0f, 2.0f);
        charm.texOffs(10, 20);
        charm.addBox(-1.0f, 1.0f, -1.5f, 2.0f, 2.0f, 0.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createWarpDrive() {
        CubeListBuilder charm = CubeListBuilder.create();
        charm.texOffs(0, 16);
        charm.addBox(-2.5f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f);
        charm.texOffs(0, 24);
        charm.addBox(-3.0f, 1.0f, -1.0f, 1.0f, 2.0f, 2.0f);
        charm.texOffs(6, 24);
        charm.addBox(2.0f, 1.0f, -1.0f, 1.0f, 2.0f, 2.0f);
        charm.texOffs(0, 28);
        charm.addBox(-2.5f, 1.0f, 0.0f, 5.0f, 2.0f, 0.0f);
        charm.texOffs(0, 30);
        charm.addBox(-2.5f, 2.0f, -1.0f, 5.0f, 0.0f, 2.0f);
        return BeltModel.createBelt(charm);
    }
}

