/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.item;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.menu.me.common.MEStorageMenu;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.me.cell.ISourceCellItem;
import gripe._90.arseng.me.cell.SourceCellHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class PortableSourceCellItem
extends AbstractPortableCell
implements ISourceCellItem {
    private final StorageTier tier;

    public PortableSourceCellItem(Item.Properties props, StorageTier tier) {
        super(MEStorageMenu.PORTABLE_FLUID_CELL_TYPE, props, 11562973);
        this.tier = tier;
    }

    public StorageTier getTier() {
        return this.tier;
    }

    @Override
    public long getTotalBytes() {
        return 50L * (long)Math.pow(4.0, this.tier.index() - 1);
    }

    @Override
    public double getIdleDrain() {
        return this.tier.idleDrain();
    }

    public ResourceLocation getRecipeId() {
        return ArsEnergistique.makeId(Objects.requireNonNull(this.getRegistryName()).getPath());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        SourceCellHandler.INSTANCE.addCellInformationToTooltip(stack, lines);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return SourceCellHandler.INSTANCE.getTooltipImage(stack);
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 * (double)(Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack)) + 1);
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)3, (arg_0, arg_1) -> ((PortableSourceCellItem)this).onUpgradesChanged(arg_0, arg_1));
    }
}

