/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zeroregard.ars_technica.entity.ArcaneProcessEntity;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.Color;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcanePolishEntity
extends ArcaneProcessEntity
implements GeoEntity {
    protected double distanceToItem = 0.5;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ArcanePolishEntity(Vec3 position, Level world, int maxAmountToPolish, float speed, Color color, List<ItemEntity> polishableEntities) {
        super((EntityType)EntityRegistry.ARCANE_POLISH_ENTITY.get(), position, world, maxAmountToPolish, speed, color, polishableEntities);
    }

    public ArcanePolishEntity(EntityType<ArcanePolishEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            AllSoundEvents.SANDING_SHORT.playOnServer(this.world, (Vec3i)this.blockPosition(), 0.5f, 0.75f + this.speed / 8.0f);
        }
    }

    @Override
    protected void process(ItemEntity item) {
        this.polish(item);
    }

    private void polish(ItemEntity item) {
        ItemStack currentStack = item.getItem();
        if (currentStack.getCount() > 0) {
            List polishingRecipes = SandPaperPolishingRecipe.getMatchingRecipes((Level)this.world, (ItemStack)currentStack);
            if (polishingRecipes.isEmpty()) {
                this.processableEntities.remove(this.currentItem);
                this.currentItem = null;
                return;
            }
            Vec3 currentPos = this.currentItem.getPosition(1.0f);
            this.setPos(currentPos.add(Math.random() / 8.0, this.distanceToItem, Math.random() / 8.0));
            RegistryAccess registryAccess = this.world.registryAccess();
            RecipeHolder firstRecipe = (RecipeHolder)polishingRecipes.getFirst();
            Recipe recipe = firstRecipe.value();
            ItemStack polishedStack = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            polishedStack.setCount(1);
            this.growOutput(item, polishedStack);
            currentStack.shrink(1);
            ++this.amountProcessed;
            AllSoundEvents.CONTROLLER_PUT.playOnServer(this.world, (Vec3i)this.blockPosition(), 0.75f, 1.5f + this.speed / 16.0f);
        }
        if (currentStack.getCount() <= 0) {
            this.currentItem = null;
        }
    }

    @Override
    protected void moveToItem() {
        this.setPos(this.currentItem.position().add(0.0, this.distanceToItem, 0.0));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "polishController", 0, this::polishAnimationPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState polishAnimationPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("polish"));
        event.getController().setAnimationSpeed((double)this.speed);
        return PlayState.CONTINUE;
    }
}

