/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.gui;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import com.zeroregard.ars_technica.block.SourceMotorBlockEntity;
import com.zeroregard.ars_technica.client.gui.AllGuiTextures;
import com.zeroregard.ars_technica.client.gui.RenderableScrollInput;
import com.zeroregard.ars_technica.network.ConfigureSourceMotorPacket;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class SourceMotorScreen
extends AbstractSimiScreen {
    private final SourceMotorBlockEntity blockEntity;
    private ScrollInput stressRatioSlider;
    private final AllGuiTextures background = AllGuiTextures.SOURCE_MOTOR_SCREEN;

    public SourceMotorScreen(SourceMotorBlockEntity be) {
        super((Component)CreateLang.translateDirect((String)"gui.source_motor.title", (Object[])new Object[0]));
        this.blockEntity = be;
    }

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(15, 0);
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.stressRatioSlider = new RenderableScrollInput(x + 8, y + 39, 213, 9).withRange(0, 101).titled(CreateLang.translateDirect((String)"gui.source_motor.stress_units_ratio", (Object[])new Object[0])).calling(state -> {
            this.blockEntity.setGeneratedStressUnitsRatio((int)state);
            this.stressRatioSlider.titled(CreateLang.translateDirect((String)"gui.source_motor.stress_units_ratio", (Object[])new Object[]{state}));
        }).setState(this.blockEntity.generatedStressUnitsRatio);
        this.addRenderableWidget((GuiEventListener)this.stressRatioSlider);
        IconButton confirmButton = new IconButton(x + 202, y + 75, (ScreenElement)AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> this.onClose());
        this.addRenderableWidget((GuiEventListener)confirmButton);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.title, x + (this.background.width - 8) / 2 - this.font.width((FormattedText)this.title) / 2, y + 4, 5841956, false);
        ((RenderableScrollInput)this.stressRatioSlider).renderSlider(String.valueOf(this.stressRatioSlider.getState()), graphics, this.font, "%");
    }

    public void removed() {
        this.send();
    }

    protected void send() {
        ConfigureSourceMotorPacket packet = new ConfigureSourceMotorPacket(this.blockEntity.getBlockPos(), this.stressRatioSlider.getState());
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)packet);
    }
}

