/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.schematics.cannon.LaunchedItem;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonRenderer;
import com.zeroregard.ars_technica.api.ITechnomancerAware;
import com.zeroregard.ars_technica.client.block.AllPartialModels;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ArcaneSchematiccannonRenderer
extends SchematicannonRenderer {
    private static float accumulatedTime = 0.0f;

    public ArcaneSchematiccannonRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ITechnomancerAware technomancerAware;
        boolean blocksLaunching;
        accumulatedTime += (float)Minecraft.getInstance().getFrameTimeNs() / 1.0E9f;
        boolean bl = blocksLaunching = !blockEntity.flyingBlocks.isEmpty();
        if (blocksLaunching) {
            ArcaneSchematiccannonRenderer.renderLaunchedBlocks(blockEntity, partialTicks, ms, buffer, light, overlay);
        }
        if (blockEntity instanceof ITechnomancerAware && (technomancerAware = (ITechnomancerAware)blockEntity).isTechnomancerNearby()) {
            this.renderCannonModel(blockEntity, partialTicks, ms, buffer, light, overlay);
        }
    }

    private static void renderLaunchedBlocks(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0) continue;
            Vec3 start = Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos().above());
            Vec3 target = Vec3.atCenterOf((Vec3i)launched.target);
            Vec3 distance = target.subtract(start);
            double yDifference = target.y - start.y;
            double throwHeight = Math.sqrt(distance.lengthSqr()) * (double)0.6f + yDifference;
            Vec3 cannonOffset = distance.add(0.0, throwHeight, 0.0).normalize().scale(2.0);
            start = start.add(cannonOffset);
            yDifference = target.y - start.y;
            float progress = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            Vec3 blockLocationXZ = target.subtract(start).scale((double)progress).multiply(1.0, 0.0, 1.0);
            float t = progress;
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * yDifference;
            Vec3 blockLocation = blockLocationXZ.add(0.5, yOffset + 1.5, 0.5).add(cannonOffset);
            ms.pushPose();
            ms.translate(blockLocation.x, blockLocation.y, blockLocation.z);
            ms.translate(0.125f, 0.125f, 0.125f);
            ms.mulPose(Axis.YP.rotationDegrees(360.0f * t));
            ms.mulPose(Axis.XP.rotationDegrees(360.0f * t));
            ms.translate(-0.125f, -0.125f, -0.125f);
            if (launched instanceof LaunchedItem.ForBlockState) {
                BlockState state = launched instanceof LaunchedItem.ForBelt ? AllBlocks.SHAFT.getDefaultState() : ((LaunchedItem.ForBlockState)launched).state;
                float scale = 0.3f;
                ms.scale(scale, scale, scale);
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, ms, buffer, light, overlay, VirtualRenderHelper.VIRTUAL_DATA, null);
            } else if (launched instanceof LaunchedItem.ForEntity) {
                float scale = 1.2f;
                ms.scale(scale, scale, scale);
                Minecraft.getInstance().getItemRenderer().renderStatic(launched.stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, blockEntity.getLevel(), 0);
            }
            ms.popPose();
            if (launched.ticksRemaining != launched.totalTicks || !blockEntity.firstRenderTick) continue;
            start = start.subtract(0.5, 0.5, 0.5);
            blockEntity.firstRenderTick = false;
            for (int i = 0; i < 10; ++i) {
                RandomSource r = blockEntity.getLevel().getRandom();
                double sX = cannonOffset.x * (double)0.01f;
                double sY = (cannonOffset.y + 1.0) * (double)0.01f;
                double sZ = cannonOffset.z * (double)0.01f;
                double rX = (double)r.nextFloat() - sX * 40.0;
                double rY = (double)r.nextFloat() - sY * 40.0;
                double rZ = (double)r.nextFloat() - sZ * 40.0;
                blockEntity.getLevel().addParticle((ParticleOptions)ParticleTypes.CLOUD, start.x + rX, start.y + rY, start.z + rZ, sX, sY, sZ);
            }
        }
    }

    private void renderCannonModel(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = blockEntity.getBlockState();
        BlockPos pos = blockEntity.getBlockPos();
        double[] cannonAngles = ArcaneSchematiccannonRenderer.getCannonAngles((SchematicannonBlockEntity)blockEntity, (BlockPos)pos, (float)partialTicks);
        double yaw = cannonAngles[0];
        double pitch = cannonAngles[1];
        double recoil = ArcaneSchematiccannonRenderer.getRecoil((SchematicannonBlockEntity)blockEntity, (float)partialTicks);
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        double distSq = camPos.distanceToSqr(Vec3.atCenterOf((Vec3i)pos));
        double distance = Math.sqrt(distSq);
        float alpha = 1.0f;
        if (distance > 4.0) {
            alpha = (float)Mth.clamp((double)(1.0 - (distance - 4.0) / 4.0), (double)0.0, (double)1.0);
        }
        int alphaInt = Math.round(255.0f * alpha);
        ms.pushPose();
        double translateX = 0.5 + 0.005 * Math.sin(accumulatedTime * 30.0f);
        double translateZ = 0.5 + 0.005 * Math.cos(accumulatedTime * 30.0f);
        SuperByteBuffer pipe = CachedBuffers.partial((PartialModel)AllPartialModels.ARCANE_PIPE, (BlockState)state);
        pipe.translate(0.5f, 0.9375f, 0.5f);
        pipe.scale(1.05f);
        pipe.rotate((float)((yaw + 90.0) / 180.0 * Math.PI), Direction.UP);
        pipe.rotate((float)(pitch / 180.0 * Math.PI), Direction.SOUTH);
        pipe.translate(-translateX, -0.9375, -translateZ);
        pipe.translate(0.0, -recoil / 100.0, 0.0);
        pipe.light(0xF000F0).color(255, 255, 255, alphaInt).renderInto(ms, buffer.getBuffer(RenderType.translucentMovingBlock()));
        ms.popPose();
    }
}

