/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.util.Comparator;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.BytesRefBuilder;
import org.apache.lucene.ars_nouveau.util.BytesRefComparator;
import org.apache.lucene.ars_nouveau.util.IntroSorter;
import org.apache.lucene.ars_nouveau.util.MSBRadixSorter;
import org.apache.lucene.ars_nouveau.util.Sorter;

public abstract class StringSorter
extends Sorter {
    private final Comparator<BytesRef> cmp;
    protected final BytesRefBuilder scratch1 = new BytesRefBuilder();
    protected final BytesRefBuilder scratch2 = new BytesRefBuilder();
    protected final BytesRefBuilder pivotBuilder = new BytesRefBuilder();
    protected final BytesRef scratchBytes1 = new BytesRef();
    protected final BytesRef scratchBytes2 = new BytesRef();
    protected final BytesRef pivot = new BytesRef();

    protected StringSorter(Comparator<BytesRef> cmp) {
        this.cmp = cmp;
    }

    protected abstract void get(BytesRefBuilder var1, BytesRef var2, int var3);

    @Override
    protected int compare(int i, int j) {
        this.get(this.scratch1, this.scratchBytes1, i);
        this.get(this.scratch2, this.scratchBytes2, j);
        return this.cmp.compare(this.scratchBytes1, this.scratchBytes2);
    }

    @Override
    public void sort(int from, int to) {
        Comparator<BytesRef> comparator = this.cmp;
        if (comparator instanceof BytesRefComparator) {
            BytesRefComparator bCmp = (BytesRefComparator)comparator;
            this.radixSorter(bCmp).sort(from, to);
        } else {
            this.fallbackSorter(this.cmp).sort(from, to);
        }
    }

    protected Sorter radixSorter(BytesRefComparator cmp) {
        return new MSBStringRadixSorter(cmp);
    }

    protected Sorter fallbackSorter(final Comparator<BytesRef> cmp) {
        return new IntroSorter(){

            @Override
            protected void swap(int i, int j) {
                StringSorter.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                StringSorter.this.get(StringSorter.this.scratch1, StringSorter.this.scratchBytes1, i);
                StringSorter.this.get(StringSorter.this.scratch2, StringSorter.this.scratchBytes2, j);
                return cmp.compare(StringSorter.this.scratchBytes1, StringSorter.this.scratchBytes2);
            }

            @Override
            protected void setPivot(int i) {
                StringSorter.this.get(StringSorter.this.pivotBuilder, StringSorter.this.pivot, i);
            }

            @Override
            protected int comparePivot(int j) {
                StringSorter.this.get(StringSorter.this.scratch1, StringSorter.this.scratchBytes1, j);
                return cmp.compare(StringSorter.this.pivot, StringSorter.this.scratchBytes1);
            }
        };
    }

    protected class MSBStringRadixSorter
    extends MSBRadixSorter {
        private final BytesRefComparator cmp;

        protected MSBStringRadixSorter(BytesRefComparator cmp) {
            super(cmp.comparedBytesCount);
            this.cmp = cmp;
        }

        @Override
        protected void swap(int i, int j) {
            StringSorter.this.swap(i, j);
        }

        @Override
        protected int byteAt(int i, int k) {
            StringSorter.this.get(StringSorter.this.scratch1, StringSorter.this.scratchBytes1, i);
            return this.cmp.byteAt(StringSorter.this.scratchBytes1, k);
        }

        @Override
        protected Sorter getFallbackSorter(int k) {
            return StringSorter.this.fallbackSorter((o1, o2) -> this.cmp.compare((BytesRef)o1, (BytesRef)o2, k));
        }
    }
}

