/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.ars_nouveau.util.InfoStream;

public final class JavaLoggingInfoStream
extends InfoStream {
    private final Map<String, Logger> cache = new ConcurrentHashMap<String, Logger>();
    private final Function<String, String> componentToLoggerName;
    private final Level level;

    public JavaLoggingInfoStream(Level level) {
        this("org.apache.lucene.ars_nouveau.", level);
    }

    public JavaLoggingInfoStream(String namePrefix, Level level) {
        this(Objects.requireNonNull(namePrefix, "namePrefix")::concat, level);
    }

    public JavaLoggingInfoStream(Function<String, String> componentToLoggerName, Level level) {
        this.componentToLoggerName = Objects.requireNonNull(componentToLoggerName, "componentToLoggerName");
        this.level = Objects.requireNonNull(level, "level");
    }

    @Override
    public void message(String component, String message) {
        this.getLogger(component).logp(this.level, null, null, message);
    }

    @Override
    public boolean isEnabled(String component) {
        return this.getLogger(component).isLoggable(this.level);
    }

    @Override
    public void close() {
        this.cache.clear();
    }

    private Logger getLogger(String component) {
        return this.cache.computeIfAbsent(Objects.requireNonNull(component, "component"), c -> Logger.getLogger(this.componentToLoggerName.apply((String)c)));
    }
}

