/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search.comparators;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.LeafFieldComparator;
import org.apache.lucene.ars_nouveau.search.Pruning;
import org.apache.lucene.ars_nouveau.search.comparators.NumericComparator;
import org.apache.lucene.ars_nouveau.util.NumericUtils;

public class LongComparator
extends NumericComparator<Long> {
    private final long[] values;
    protected long topValue;
    protected long bottom;

    public LongComparator(int numHits, String field, Long missingValue, boolean reverse, Pruning pruning) {
        super(field, missingValue != null ? missingValue : 0L, reverse, pruning, 8);
        this.values = new long[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Long.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Long value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public Long value(int slot) {
        return this.values[slot];
    }

    @Override
    protected long missingValueAsComparableLong() {
        return (Long)this.missingValue;
    }

    @Override
    protected long sortableBytesToLong(byte[] bytes) {
        return NumericUtils.sortableBytesToLong(bytes, 0);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new LongLeafComparator(context);
    }

    public class LongLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public LongLeafComparator(LeafReaderContext context) throws IOException {
            super(LongComparator.this, context);
        }

        private long getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return this.docValues.longValue();
            }
            return (Long)LongComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            LongComparator.this.bottom = LongComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Long.compare(LongComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Long.compare(LongComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            LongComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected long bottomAsComparableLong() {
            return LongComparator.this.bottom;
        }

        @Override
        protected long topAsComparableLong() {
            return LongComparator.this.topValue;
        }
    }
}

