/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.ImpactsDISI;
import org.apache.lucene.ars_nouveau.search.MaxScoreCache;
import org.apache.lucene.ars_nouveau.search.PhraseMatcher;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;

class PhraseScorer
extends Scorer {
    final DocIdSetIterator approximation;
    final ImpactsDISI impactsApproximation;
    final MaxScoreCache maxScoreCache;
    final PhraseMatcher matcher;
    final ScoreMode scoreMode;
    private final Similarity.SimScorer simScorer;
    private final NumericDocValues norms;
    final float matchCost;
    private float minCompetitiveScore = 0.0f;
    private float freq = 0.0f;

    PhraseScorer(PhraseMatcher matcher, ScoreMode scoreMode, Similarity.SimScorer simScorer, NumericDocValues norms) {
        this.matcher = matcher;
        this.scoreMode = scoreMode;
        this.simScorer = simScorer;
        this.norms = norms;
        this.matchCost = matcher.getMatchCost();
        this.approximation = matcher.approximation();
        this.impactsApproximation = matcher.impactsApproximation();
        this.maxScoreCache = this.impactsApproximation.getMaxScoreCache();
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.approximation){

            @Override
            public boolean matches() throws IOException {
                PhraseScorer.this.matcher.reset();
                if (PhraseScorer.this.scoreMode == ScoreMode.TOP_SCORES && PhraseScorer.this.minCompetitiveScore > 0.0f) {
                    float maxFreq = PhraseScorer.this.matcher.maxFreq();
                    long norm = 1L;
                    if (PhraseScorer.this.norms != null && PhraseScorer.this.norms.advanceExact(PhraseScorer.this.docID())) {
                        norm = PhraseScorer.this.norms.longValue();
                    }
                    if (PhraseScorer.this.simScorer.score(maxFreq, norm) < PhraseScorer.this.minCompetitiveScore) {
                        return false;
                    }
                }
                PhraseScorer.this.freq = 0.0f;
                return PhraseScorer.this.matcher.nextMatch();
            }

            @Override
            public float matchCost() {
                return PhraseScorer.this.matchCost;
            }
        };
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        if (this.freq == 0.0f) {
            this.freq = this.matcher.sloppyWeight();
            while (this.matcher.nextMatch()) {
                this.freq += this.matcher.sloppyWeight();
            }
        }
        long norm = 1L;
        if (this.norms != null && this.norms.advanceExact(this.docID())) {
            norm = this.norms.longValue();
        }
        return this.simScorer.score(this.freq, norm);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.minCompetitiveScore = minScore;
        this.impactsApproximation.setMinCompetitiveScore(minScore);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }
}

