/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.facet.iterators;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.ars_nouveau.sandbox.facet.iterators.OrdinalIterator;

public final class TaxonomyChildrenOrdinalIterator
implements OrdinalIterator {
    private final OrdinalIterator sourceOrds;
    private final ParallelTaxonomyArrays.IntArray parents;
    private final int parentOrd;

    public TaxonomyChildrenOrdinalIterator(OrdinalIterator sourceOrds, ParallelTaxonomyArrays.IntArray parents, int parentOrd) {
        this.sourceOrds = sourceOrds;
        this.parents = parents;
        assert (parentOrd != -1) : "Parent Ordinal is not valid";
        this.parentOrd = parentOrd;
    }

    @Override
    public int nextOrd() throws IOException {
        int ord = this.sourceOrds.nextOrd();
        while (ord != -1) {
            if (this.parents.get(ord) == this.parentOrd) {
                return ord;
            }
            ord = this.sourceOrds.nextOrd();
        }
        return -1;
    }
}

