/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.ars_nouveau.queries.intervals.DisiWrapper;

final class DisiPriorityQueue
implements Iterable<DisiWrapper> {
    private final DisiWrapper[] heap;
    private int size;

    static int leftNode(int node) {
        return (node + 1 << 1) - 1;
    }

    static int rightNode(int leftNode) {
        return leftNode + 1;
    }

    static int parentNode(int node) {
        return (node + 1 >>> 1) - 1;
    }

    public DisiPriorityQueue(int maxSize) {
        this.heap = new DisiWrapper[maxSize];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public DisiWrapper top() {
        return this.heap[0];
    }

    public DisiWrapper topList() {
        DisiWrapper[] heap = this.heap;
        int size = this.size;
        DisiWrapper list = heap[0];
        list.next = null;
        if (size >= 3) {
            list = this.topList(list, heap, size, 1);
            list = this.topList(list, heap, size, 2);
        } else if (size == 2 && heap[1].doc == list.doc) {
            list = this.prepend(heap[1], list);
        }
        return list;
    }

    private DisiWrapper prepend(DisiWrapper w1, DisiWrapper w2) {
        w1.next = w2;
        return w1;
    }

    private DisiWrapper topList(DisiWrapper list, DisiWrapper[] heap, int size, int i) {
        DisiWrapper w = heap[i];
        if (w.doc == list.doc) {
            list = this.prepend(w, list);
            int left = DisiPriorityQueue.leftNode(i);
            int right = left + 1;
            if (right < size) {
                list = this.topList(list, heap, size, left);
                list = this.topList(list, heap, size, right);
            } else if (left < size && heap[left].doc == list.doc) {
                list = this.prepend(heap[left], list);
            }
        }
        return list;
    }

    public DisiWrapper add(DisiWrapper entry) {
        DisiWrapper[] heap = this.heap;
        int size = this.size;
        heap[size] = entry;
        this.upHeap(size);
        this.size = size + 1;
        return heap[0];
    }

    public DisiWrapper pop() {
        DisiWrapper[] heap = this.heap;
        DisiWrapper result = heap[0];
        int i = --this.size;
        heap[0] = heap[i];
        heap[i] = null;
        this.downHeap(i);
        return result;
    }

    public DisiWrapper updateTop() {
        this.downHeap(this.size);
        return this.heap[0];
    }

    DisiWrapper updateTop(DisiWrapper topReplacement) {
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    void upHeap(int i) {
        DisiWrapper node = this.heap[i];
        int nodeDoc = node.doc;
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && nodeDoc < this.heap[j].doc) {
            this.heap[i] = this.heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        this.heap[i] = node;
    }

    void downHeap(int size) {
        int i = 0;
        DisiWrapper node = this.heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size && this.heap[k].doc < this.heap[j].doc) {
                j = k;
            }
            if (this.heap[j].doc < node.doc) {
                do {
                    this.heap[i] = this.heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size || this.heap[k].doc >= this.heap[j].doc) continue;
                    j = k;
                } while (j < size && this.heap[j].doc < node.doc);
                this.heap[i] = node;
            }
        }
    }

    @Override
    public Iterator<DisiWrapper> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }
}

