/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.queries.intervals.ConjunctionMatchesIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatches;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalQuery;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;

abstract class ConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;

    protected ConjunctionIntervalsSource(List<IntervalsSource> subSources) {
        assert (subSources.size() > 1);
        this.subSources = subSources;
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field, v);
        }
    }

    @Override
    public final IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.combine(subIntervals);
    }

    protected abstract IntervalIterator combine(List<IntervalIterator> var1);

    protected IntervalMatchesIterator createMatchesIterator(IntervalIterator it, List<IntervalMatchesIterator> subs) {
        return new ConjunctionMatchesIterator(it, subs);
    }

    @Override
    public final IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<IntervalMatchesIterator> subs = new ArrayList<IntervalMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalMatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(mi);
        }
        IntervalIterator it = this.combine(subs.stream().map(m -> IntervalMatches.wrapMatches(m, doc)).toList());
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return this.createMatchesIterator(it, subs);
    }
}

