/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.ValueSource;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;

public class MaxDocValueSource
extends ValueSource {
    public String name() {
        return "maxdoc";
    }

    @Override
    public String description() {
        return this.name() + "()";
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        context.put("searcher", searcher);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        return new DocFreqValueSource.ConstIntDocValues(searcher.getIndexReader().maxDoc(), this);
    }

    @Override
    public boolean equals(Object o) {
        return this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

