/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.ValueSource;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.VectorSimilarityFunction;

public class FloatVectorSimilarityFunction
extends VectorSimilarityFunction {
    public FloatVectorSimilarityFunction(org.apache.lucene.ars_nouveau.index.VectorSimilarityFunction similarityFunction, ValueSource vector1, ValueSource vector2) {
        super(similarityFunction, vector1, vector2);
    }

    @Override
    protected float func(int doc, FunctionValues f1, FunctionValues f2) throws IOException {
        float[] v1 = f1.floatVectorVal(doc);
        float[] v2 = f2.floatVectorVal(doc);
        if (v1 == null || v2 == null) {
            return 0.0f;
        }
        assert (v1.length == v2.length) : "Vectors must have the same length";
        return this.similarityFunction.compare(v1, v2);
    }
}

