/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.internal.vectorization;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.lucene.ars_nouveau.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.ars_nouveau.internal.vectorization.DefaultVectorizationProvider;
import org.apache.lucene.ars_nouveau.internal.vectorization.PostingDecodingUtil;
import org.apache.lucene.ars_nouveau.internal.vectorization.VectorUtilSupport;
import org.apache.lucene.ars_nouveau.store.IndexInput;
import org.apache.lucene.ars_nouveau.util.Constants;

public abstract class VectorizationProvider {
    static final OptionalInt TESTS_VECTOR_SIZE;
    static final boolean TESTS_FORCE_INTEGER_VECTORS;
    static final int UPPER_JAVA_FEATURE_VERSION;
    private static final String UPPER_JAVA_FEATURE_VERSION_SYSPROP = "org.apache.lucene.ars_nouveau.vectorization.upperJavaFeatureVersion";
    private static final int DEFAULT_UPPER_JAVA_FEATURE_VERSION = 23;
    private static final Logger LOG;
    private static final Set<String> VALID_CALLERS;

    private static int getUpperJavaFeatureVersion() {
        int runtimeVersion = 23;
        try {
            String str = System.getProperty(UPPER_JAVA_FEATURE_VERSION_SYSPROP);
            if (str != null) {
                runtimeVersion = Math.max(Integer.parseInt(str), runtimeVersion);
            }
        }
        catch (NumberFormatException | SecurityException ignored) {
            Logger.getLogger(VectorizationProvider.class.getName()).warning("Cannot read sysprop org.apache.lucene.vectorization.upperJavaFeatureVersion, so the default value will be used.");
        }
        return runtimeVersion;
    }

    public static VectorizationProvider getInstance() {
        VectorizationProvider.ensureCaller();
        return Objects.requireNonNull(Holder.INSTANCE, "call to getInstance() from subclass of VectorizationProvider");
    }

    VectorizationProvider() {
    }

    public abstract VectorUtilSupport getVectorUtilSupport();

    public abstract FlatVectorsScorer getLucene99FlatVectorsScorer();

    public abstract PostingDecodingUtil newPostingDecodingUtil(IndexInput var1) throws IOException;

    static VectorizationProvider lookup(boolean testMode) {
        int runtimeVersion = Runtime.version().feature();
        assert (runtimeVersion >= 21);
        if (runtimeVersion <= UPPER_JAVA_FEATURE_VERSION) {
            if (!Constants.IS_HOTSPOT_VM) {
                LOG.warning("Java runtime is not using Hotspot VM; Java vector incubator API can't be enabled.");
                return new DefaultVectorizationProvider();
            }
            if (Constants.IS_JVMCI_VM) {
                LOG.warning("Java runtime is using JVMCI Compiler; Java vector incubator API can't be enabled.");
                return new DefaultVectorizationProvider();
            }
            Optional<Module> vectorMod = VectorizationProvider.lookupVectorModule();
            if (vectorMod.isEmpty()) {
                LOG.warning("Java vector incubator module is not readable. For optimal vector performance, pass '--add-modules jdk.incubator.vector' to enable Vector API.");
                return new DefaultVectorizationProvider();
            }
            vectorMod.ifPresent(VectorizationProvider.class.getModule()::addReads);
            if (!testMode) {
                if (TESTS_VECTOR_SIZE.isPresent() || TESTS_FORCE_INTEGER_VECTORS) {
                    LOG.warning("Vector bitsize and/or integer vectors enforcement; using default vectorization provider outside of testMode");
                    return new DefaultVectorizationProvider();
                }
                if (Constants.IS_CLIENT_VM) {
                    LOG.warning("C2 compiler is disabled; Java vector incubator API can't be enabled");
                    return new DefaultVectorizationProvider();
                }
            }
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> cls = lookup.findClass("org.apache.lucene.ars_nouveau.internal.vectorization.PanamaVectorizationProvider");
                MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE));
                try {
                    return constr.invoke();
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.warning("Java vector incubator API was not enabled. " + uoe.getMessage());
                    return new DefaultVectorizationProvider();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new AssertionError((Object)th);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new LinkageError("PanamaVectorizationProvider is missing correctly typed constructor", e);
            }
            catch (ClassNotFoundException cnfe) {
                throw new LinkageError("PanamaVectorizationProvider is missing in Lucene JAR file", cnfe);
            }
        }
        LOG.warning("You are running with unsupported Java " + runtimeVersion + ". To make full use of the Vector API, please update Apache Lucene.");
        return new DefaultVectorizationProvider();
    }

    private static Optional<Module> lookupVectorModule() {
        return Optional.ofNullable(VectorizationProvider.class.getModule().getLayer()).orElse(ModuleLayer.boot()).findModule("jdk.incubator.vector");
    }

    private static void ensureCaller() {
        boolean validCaller = StackWalker.getInstance().walk(s -> s.skip(2L).limit(1L).map(StackWalker.StackFrame::getClassName).allMatch(VALID_CALLERS::contains));
        if (!validCaller) {
            throw new UnsupportedOperationException("VectorizationProvider is internal and can only be used by known Lucene classes.");
        }
    }

    static {
        UPPER_JAVA_FEATURE_VERSION = VectorizationProvider.getUpperJavaFeatureVersion();
        OptionalInt vs = OptionalInt.empty();
        try {
            vs = Stream.ofNullable(System.getProperty("tests.vectorsize")).filter(Predicate.not(Set.of("", "default")::contains)).mapToInt(Integer::parseInt).findAny();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        TESTS_VECTOR_SIZE = vs;
        boolean enforce = false;
        try {
            enforce = Boolean.getBoolean("tests.forceintegervectors");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        TESTS_FORCE_INTEGER_VECTORS = enforce;
        LOG = Logger.getLogger(VectorizationProvider.class.getName());
        VALID_CALLERS = Set.of("org.apache.lucene.ars_nouveau.codecs.hnsw.FlatVectorScorerUtil", "org.apache.lucene.ars_nouveau.util.VectorUtil", "org.apache.lucene.ars_nouveau.codecs.lucene101.Lucene101PostingsReader", "org.apache.lucene.ars_nouveau.codecs.lucene101.PostingIndexInput");
    }

    private static final class Holder {
        static final VectorizationProvider INSTANCE = VectorizationProvider.lookup(false);

        private Holder() {
        }
    }
}

