/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.ars_nouveau.codecs.Codec;
import org.apache.lucene.ars_nouveau.codecs.CodecUtil;
import org.apache.lucene.ars_nouveau.index.CorruptIndexException;
import org.apache.lucene.ars_nouveau.index.IndexCommit;
import org.apache.lucene.ars_nouveau.index.IndexFileNames;
import org.apache.lucene.ars_nouveau.index.IndexFormatTooOldException;
import org.apache.lucene.ars_nouveau.index.IndexNotFoundException;
import org.apache.lucene.ars_nouveau.index.IndexWriter;
import org.apache.lucene.ars_nouveau.index.MergePolicy;
import org.apache.lucene.ars_nouveau.index.SegmentCommitInfo;
import org.apache.lucene.ars_nouveau.index.SegmentInfo;
import org.apache.lucene.ars_nouveau.store.ChecksumIndexInput;
import org.apache.lucene.ars_nouveau.store.DataInput;
import org.apache.lucene.ars_nouveau.store.Directory;
import org.apache.lucene.ars_nouveau.store.IOContext;
import org.apache.lucene.ars_nouveau.store.IndexOutput;
import org.apache.lucene.ars_nouveau.util.CollectionUtil;
import org.apache.lucene.ars_nouveau.util.IOUtils;
import org.apache.lucene.ars_nouveau.util.StringHelper;
import org.apache.lucene.ars_nouveau.util.Version;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public static final int VERSION_74 = 9;
    public static final int VERSION_86 = 10;
    static final int VERSION_CURRENT = 10;
    static final String OLD_SEGMENTS_GEN = "segments.gen";
    public long counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream;
    private byte[] id;
    private Version luceneVersion;
    private Version minSegmentLuceneVersion;
    private final int indexCreatedVersionMajor;
    boolean pendingCommit;

    public SegmentInfos(int indexCreatedVersionMajor) {
        if (indexCreatedVersionMajor > Version.LATEST.major) {
            throw new IllegalArgumentException("indexCreatedVersionMajor is in the future: " + indexCreatedVersionMajor);
        }
        if (indexCreatedVersionMajor < 6) {
            throw new IllegalArgumentException("indexCreatedVersionMajor must be >= 6, got: " + indexCreatedVersionMajor);
        }
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
    }

    public SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    public static long getLastCommitGeneration(String[] files) {
        long max = -1L;
        for (String file : files) {
            long gen;
            if (!file.startsWith("segments") || file.startsWith(OLD_SEGMENTS_GEN) || (gen = SegmentInfos.generationFromSegmentsFileName(file)) <= max) continue;
            max = gen;
        }
        return max;
    }

    public static long getLastCommitGeneration(Directory directory) throws IOException {
        return SegmentInfos.getLastCommitGeneration(directory.listAll());
    }

    public static String getLastCommitSegmentsFileName(String[] files) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(files));
    }

    public static String getLastCommitSegmentsFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(directory));
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals(OLD_SEGMENTS_GEN)) {
            throw new IllegalArgumentException("\"segments.gen\" is not a valid segment file name since 4.0");
        }
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public static final SegmentInfos readCommit(Directory directory, String segmentFileName) throws IOException {
        return SegmentInfos.readCommit(directory, segmentFileName, Version.MIN_SUPPORTED_MAJOR);
    }

    public static final SegmentInfos readCommit(Directory directory, String segmentFileName, int minSupportedMajorVersion) throws IOException {
        long generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
        ChecksumIndexInput input = directory.openChecksumInput(segmentFileName);
        try {
            SegmentInfos segmentInfos = SegmentInfos.readCommit(directory, input, generation, minSupportedMajorVersion);
            return segmentInfos;
        }
        catch (EOFException | FileNotFoundException | NoSuchFileException e) {
            throw new CorruptIndexException("Unexpected file read error while reading index.", input, (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public static final SegmentInfos readCommit(Directory directory, ChecksumIndexInput input, long generation) throws IOException {
        return SegmentInfos.readCommit(directory, input, generation, Version.MIN_SUPPORTED_MAJOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SegmentInfos readCommit(Directory directory, ChecksumIndexInput input, long generation, int minSupportedMajorVersion) throws IOException {
        Throwable priorE = null;
        int format = -1;
        try {
            int magic = CodecUtil.readBEInt(input);
            if (magic != 1071082519) {
                throw new IndexFormatTooOldException(input, magic, 1071082519, 1071082519);
            }
            format = CodecUtil.checkHeaderNoMagic(input, "segments", 9, 10);
            byte[] id = new byte[16];
            input.readBytes(id, 0, id.length);
            CodecUtil.checkIndexHeaderSuffix(input, Long.toString(generation, 36));
            Version luceneVersion = Version.fromBits(input.readVInt(), input.readVInt(), input.readVInt());
            int indexCreatedVersion = input.readVInt();
            if (luceneVersion.major < indexCreatedVersion) {
                throw new CorruptIndexException("Creation version [" + indexCreatedVersion + ".x] can't be greater than the version that wrote the segment infos: [" + String.valueOf(luceneVersion) + "]", input);
            }
            if (indexCreatedVersion < minSupportedMajorVersion) {
                throw new IndexFormatTooOldException(input, "This index was initially created with Lucene " + indexCreatedVersion + ".x while the current version is " + String.valueOf(Version.LATEST) + " and Lucene only supports reading" + (String)(minSupportedMajorVersion == Version.MIN_SUPPORTED_MAJOR ? " the current and previous major versions" : " from version " + minSupportedMajorVersion + " upwards"));
            }
            SegmentInfos infos = new SegmentInfos(indexCreatedVersion);
            infos.id = id;
            infos.generation = generation;
            infos.lastGeneration = generation;
            infos.luceneVersion = luceneVersion;
            SegmentInfos.parseSegmentInfos(directory, input, infos, format);
            SegmentInfos segmentInfos = infos;
            return segmentInfos;
        }
        catch (Throwable t) {
            priorE = t;
        }
        finally {
            if (format < 9) {
                throw IOUtils.rethrowAlways(priorE);
            }
            CodecUtil.checkFooter(input, priorE);
        }
        throw new Error("Unreachable code");
    }

    private static void parseSegmentInfos(Directory directory, DataInput input, SegmentInfos infos, int format) throws IOException {
        infos.version = CodecUtil.readBELong(input);
        infos.counter = input.readVLong();
        int numSegments = CodecUtil.readBEInt(input);
        if (numSegments < 0) {
            throw new CorruptIndexException("invalid segment count: " + numSegments, input);
        }
        if (numSegments > 0) {
            infos.minSegmentLuceneVersion = Version.fromBits(input.readVInt(), input.readVInt(), input.readVInt());
        }
        long totalDocs = 0L;
        for (int seg = 0; seg < numSegments; ++seg) {
            Map<Integer, Set<String>> dvUpdateFiles;
            byte[] sciId;
            String segName = input.readString();
            byte[] segmentID = new byte[16];
            input.readBytes(segmentID, 0, segmentID.length);
            Codec codec = SegmentInfos.readCodec(input);
            SegmentInfo info = codec.segmentInfoFormat().read(directory, segName, segmentID, IOContext.DEFAULT);
            info.setCodec(codec);
            totalDocs += (long)info.maxDoc();
            long delGen = CodecUtil.readBELong(input);
            int delCount = CodecUtil.readBEInt(input);
            if (delCount < 0 || delCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + delCount + " vs maxDoc=" + info.maxDoc(), input);
            }
            long fieldInfosGen = CodecUtil.readBELong(input);
            long dvGen = CodecUtil.readBELong(input);
            int softDelCount = CodecUtil.readBEInt(input);
            if (softDelCount < 0 || softDelCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + softDelCount + " vs maxDoc=" + info.maxDoc(), input);
            }
            if (softDelCount + delCount > info.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + (softDelCount + delCount) + " vs maxDoc=" + info.maxDoc(), input);
            }
            if (format > 9) {
                byte marker = input.readByte();
                switch (marker) {
                    case 1: {
                        sciId = new byte[16];
                        input.readBytes(sciId, 0, sciId.length);
                        break;
                    }
                    case 0: {
                        sciId = null;
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("invalid SegmentCommitInfo ID marker: " + marker, input);
                    }
                }
            } else {
                sciId = null;
            }
            SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info, delCount, softDelCount, delGen, fieldInfosGen, dvGen, sciId);
            siPerCommit.setFieldInfosFiles(input.readSetOfStrings());
            int numDVFields = CodecUtil.readBEInt(input);
            if (numDVFields == 0) {
                dvUpdateFiles = Collections.emptyMap();
            } else {
                HashMap<Integer, Set<String>> map = CollectionUtil.newHashMap(numDVFields);
                for (int i = 0; i < numDVFields; ++i) {
                    map.put(CodecUtil.readBEInt(input), input.readSetOfStrings());
                }
                dvUpdateFiles = Collections.unmodifiableMap(map);
            }
            siPerCommit.setDocValuesUpdatesFiles(dvUpdateFiles);
            infos.add(siPerCommit);
            Version segmentVersion = info.getVersion();
            if (!segmentVersion.onOrAfter(infos.minSegmentLuceneVersion)) {
                throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + String.valueOf(infos.minSegmentLuceneVersion) + " but segment=" + String.valueOf(info) + " has older version=" + String.valueOf(segmentVersion), input);
            }
            if (infos.indexCreatedVersionMajor >= 7 && segmentVersion.major < infos.indexCreatedVersionMajor) {
                throw new CorruptIndexException("segments file recorded indexCreatedVersionMajor=" + infos.indexCreatedVersionMajor + " but segment=" + String.valueOf(info) + " has older version=" + String.valueOf(segmentVersion), input);
            }
            if (infos.indexCreatedVersionMajor < 7 || info.getMinVersion() != null) continue;
            throw new CorruptIndexException("segments infos must record minVersion with indexCreatedVersionMajor=" + infos.indexCreatedVersionMajor, input);
        }
        infos.userData = input.readMapOfStrings();
        if (totalDocs > (long)IndexWriter.getActualMaxDocs()) {
            throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + totalDocs, input);
        }
    }

    private static Codec readCodec(DataInput input) throws IOException {
        String name = input.readString();
        try {
            return Codec.forName(name);
        }
        catch (IllegalArgumentException e) {
            if (name.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + name + "'. Did you forget to add lucene-backward-codecs.jar?", e);
            }
            throw e;
        }
    }

    public static final SegmentInfos readLatestCommit(Directory directory) throws IOException {
        return SegmentInfos.readLatestCommit(directory, Version.MIN_SUPPORTED_MAJOR);
    }

    public static final SegmentInfos readLatestCommit(Directory directory, final int minSupportedMajorVersion) throws IOException {
        return (SegmentInfos)new FindSegmentsFile<SegmentInfos>(directory){

            @Override
            protected SegmentInfos doBody(String segmentFileName) throws IOException {
                return SegmentInfos.readCommit(this.directory, segmentFileName, minSupportedMajorVersion);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Directory directory) throws IOException {
        IndexOutput segnOutput;
        String segmentFileName;
        block4: {
            long nextGeneration = this.getNextPendingGeneration();
            segmentFileName = IndexFileNames.fileNameFromGeneration("pending_segments", "", nextGeneration);
            this.generation = nextGeneration;
            segnOutput = null;
            boolean success = false;
            try {
                segnOutput = directory.createOutput(segmentFileName, IOContext.DEFAULT);
                this.write(segnOutput);
                segnOutput.close();
                directory.sync(Collections.singleton(segmentFileName));
                success = true;
                if (!success) break block4;
                this.pendingCommit = true;
            }
            catch (Throwable throwable) {
                if (success) {
                    this.pendingCommit = true;
                } else {
                    IOUtils.closeWhileHandlingException(segnOutput);
                    IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
                }
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(segnOutput);
        IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
    }

    public void write(IndexOutput out) throws IOException {
        CodecUtil.writeIndexHeader(out, "segments", 10, StringHelper.randomId(), Long.toString(this.generation, 36));
        out.writeVInt(Version.LATEST.major);
        out.writeVInt(Version.LATEST.minor);
        out.writeVInt(Version.LATEST.bugfix);
        out.writeVInt(this.indexCreatedVersionMajor);
        CodecUtil.writeBELong(out, this.version);
        out.writeVLong(this.counter);
        CodecUtil.writeBEInt(out, this.size());
        if (this.size() > 0) {
            Version minSegmentVersion = null;
            for (SegmentCommitInfo siPerCommit : this) {
                Version segmentVersion = siPerCommit.info.getVersion();
                if (minSegmentVersion != null && segmentVersion.onOrAfter(minSegmentVersion)) continue;
                minSegmentVersion = segmentVersion;
            }
            out.writeVInt(minSegmentVersion.major);
            out.writeVInt(minSegmentVersion.minor);
            out.writeVInt(minSegmentVersion.bugfix);
        }
        for (SegmentCommitInfo siPerCommit : this) {
            SegmentInfo si = siPerCommit.info;
            if (this.indexCreatedVersionMajor >= 7 && si.minVersion == null) {
                throw new IllegalStateException("Segments must record minVersion if they have been created on or after Lucene 7: " + String.valueOf(si));
            }
            out.writeString(si.name);
            byte[] segmentID = si.getId();
            if (segmentID.length != 16) {
                throw new IllegalStateException("cannot write segment: invalid id segment=" + si.name + "id=" + StringHelper.idToString(segmentID));
            }
            out.writeBytes(segmentID, segmentID.length);
            out.writeString(si.getCodec().getName());
            CodecUtil.writeBELong(out, siPerCommit.getDelGen());
            int delCount = siPerCommit.getDelCount();
            if (delCount < 0 || delCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " delCount=" + delCount);
            }
            CodecUtil.writeBEInt(out, delCount);
            CodecUtil.writeBELong(out, siPerCommit.getFieldInfosGen());
            CodecUtil.writeBELong(out, siPerCommit.getDocValuesGen());
            int softDelCount = siPerCommit.getSoftDelCount();
            if (softDelCount < 0 || softDelCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " softDelCount=" + softDelCount);
            }
            CodecUtil.writeBEInt(out, softDelCount);
            byte[] sciId = siPerCommit.getId();
            if (sciId != null) {
                out.writeByte((byte)1);
                assert (sciId.length == 16) : "invalid SegmentCommitInfo#id: " + Arrays.toString(sciId);
                out.writeBytes(sciId, 0, sciId.length);
            } else {
                out.writeByte((byte)0);
            }
            out.writeSetOfStrings(siPerCommit.getFieldInfosFiles());
            Map<Integer, Set<String>> dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
            CodecUtil.writeBEInt(out, dvUpdatesFiles.size());
            for (Map.Entry<Integer, Set<String>> e : dvUpdatesFiles.entrySet()) {
                CodecUtil.writeBEInt(out, e.getKey());
                out.writeSetOfStrings(e.getValue());
            }
        }
        out.writeMapOfStrings(this.userData);
        CodecUtil.writeFooter(out);
    }

    public SegmentInfos clone() {
        try {
            SegmentInfos sis = (SegmentInfos)super.clone();
            sis.segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo info : this) {
                assert (info.info.getCodec() != null);
                sis.add(info.clone());
            }
            sis.userData = new HashMap<String, String>(this.userData);
            return sis;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
    }

    public void updateGeneration(SegmentInfos other) {
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
    }

    void updateGenerationVersionAndCounter(SegmentInfos other) {
        this.updateGeneration(other);
        this.version = other.version;
        this.counter = other.counter;
    }

    public void setNextWriteGeneration(long generation) {
        if (generation < this.generation) {
            throw new IllegalStateException("cannot decrease generation to " + generation + " from current generation " + this.generation);
        }
        this.generation = generation;
    }

    final void rollbackCommit(Directory dir) {
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String pending = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(dir, pending);
        }
    }

    final void prepareCommit(Directory dir) throws IOException {
        if (this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        dir.syncMetaData();
        this.write(dir);
    }

    public Collection<String> files(boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files.add(segmentFileName);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SegmentCommitInfo info = this.info(i);
            files.addAll(info.files());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String finishCommit(Directory dir) throws IOException {
        String dest;
        block8: {
            if (!this.pendingCommit) {
                throw new IllegalStateException("prepareCommit was not called");
            }
            boolean successRenameAndSync = false;
            try {
                String src = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
                dest = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
                dir.rename(src, dest);
                try {
                    dir.syncMetaData();
                    successRenameAndSync = true;
                    if (successRenameAndSync) break block8;
                }
                catch (Throwable throwable) {
                    if (!successRenameAndSync) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, dest);
                    }
                    throw throwable;
                }
                IOUtils.deleteFilesIgnoringExceptions(dir, dest);
            }
            finally {
                if (!successRenameAndSync) {
                    this.rollbackCommit(dir);
                }
            }
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return dest;
    }

    public final void commit(Directory dir) throws IOException {
        this.prepareCommit(dir);
        this.finishCommit(dir);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info = this.info(i);
            buffer.append(info.toString(0));
        }
        return buffer.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public void setUserData(Map<String, String> data, boolean doIncrementVersion) {
        this.userData = data == null ? Collections.emptyMap() : data;
        if (doIncrementVersion) {
            this.changed();
        }
    }

    void replace(SegmentInfos other) {
        this.rollbackSegmentInfos(other.asList());
        this.lastGeneration = other.lastGeneration;
        this.userData = other.userData;
    }

    public int totalMaxDoc() {
        long count = 0L;
        for (SegmentCommitInfo info : this) {
            count += (long)info.info.maxDoc();
        }
        assert (count <= (long)IndexWriter.getActualMaxDocs());
        return Math.toIntExact(count);
    }

    public void changed() {
        ++this.version;
    }

    void setVersion(long newVersion) {
        if (newVersion < this.version) {
            throw new IllegalArgumentException("newVersion (=" + newVersion + ") cannot be less than current version (=" + this.version + ")");
        }
        this.version = newVersion;
    }

    void applyMergeChanges(MergePolicy.OneMerge merge, boolean dropSegment) {
        if (this.indexCreatedVersionMajor >= 7 && merge.info.info.minVersion == null) {
            throw new IllegalArgumentException("All segments must record the minVersion for indices created on or after Lucene 7");
        }
        HashSet<SegmentCommitInfo> mergedAway = new HashSet<SegmentCommitInfo>(merge.segments);
        boolean inserted = false;
        int newSegIdx = 0;
        int cnt = this.segments.size();
        for (int segIdx = 0; segIdx < cnt; ++segIdx) {
            assert (segIdx >= newSegIdx);
            SegmentCommitInfo info = this.segments.get(segIdx);
            if (mergedAway.contains(info)) {
                if (inserted || dropSegment) continue;
                this.segments.set(segIdx, merge.info);
                inserted = true;
                ++newSegIdx;
                continue;
            }
            this.segments.set(newSegIdx, info);
            ++newSegIdx;
        }
        this.segments.subList(newSegIdx, this.segments.size()).clear();
        if (!inserted && !dropSegment) {
            this.segments.add(0, merge.info);
        }
    }

    List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> list = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo info : this) {
            assert (info.info.getCodec() != null);
            list.add(info.clone());
        }
        return list;
    }

    void rollbackSegmentInfos(List<SegmentCommitInfo> infos) {
        this.clear();
        this.addAll(infos);
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo si) {
        if (this.indexCreatedVersionMajor >= 7 && si.info.minVersion == null) {
            throw new IllegalArgumentException("All segments must record the minVersion for indices created on or after Lucene 7");
        }
        this.segments.add(si);
    }

    public void addAll(Iterable<SegmentCommitInfo> sis) {
        for (SegmentCommitInfo si : sis) {
            this.add(si);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public boolean remove(SegmentCommitInfo si) {
        return this.segments.remove(si);
    }

    void remove(int index) {
        this.segments.remove(index);
    }

    boolean contains(SegmentCommitInfo si) {
        return this.segments.contains(si);
    }

    int indexOf(SegmentCommitInfo si) {
        return this.segments.indexOf(si);
    }

    public Version getCommitLuceneVersion() {
        return this.luceneVersion;
    }

    public Version getMinSegmentLuceneVersion() {
        return this.minSegmentLuceneVersion;
    }

    public int getIndexCreatedVersionMajor() {
        return this.indexCreatedVersionMajor;
    }

    public static abstract class FindSegmentsFile<T> {
        final Directory directory;

        protected FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(IndexCommit commit) throws IOException {
            if (commit != null) {
                if (this.directory != commit.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(commit.getSegmentsFileName());
            }
            long lastGen = -1L;
            long gen = -1L;
            IOException exc = null;
            while (true) {
                lastGen = gen;
                Object[] files = this.directory.listAll();
                Object[] files2 = this.directory.listAll();
                Arrays.sort(files);
                Arrays.sort(files2);
                if (!Arrays.equals(files, files2)) continue;
                gen = SegmentInfos.getLastCommitGeneration((String[])files);
                if (infoStream != null) {
                    SegmentInfos.message("directory listing gen=" + gen);
                }
                if (gen == -1L) {
                    throw new IndexNotFoundException("no segments* file found in " + String.valueOf(this.directory) + ": files: " + Arrays.toString(files));
                }
                if (gen <= lastGen) break;
                String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    T t = this.doBody(segmentFileName);
                    if (infoStream != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return t;
                }
                catch (IOException err) {
                    if (exc == null) {
                        exc = err;
                    }
                    if (infoStream == null) continue;
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + String.valueOf(err) + "'; will retry: gen = " + gen);
                    continue;
                }
                break;
            }
            throw exc;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

