/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import org.apache.lucene.ars_nouveau.document.Field;
import org.apache.lucene.ars_nouveau.document.FieldType;
import org.apache.lucene.ars_nouveau.document.XYDocValuesPointInGeometryQuery;
import org.apache.lucene.ars_nouveau.document.XYPointSortField;
import org.apache.lucene.ars_nouveau.geo.XYCircle;
import org.apache.lucene.ars_nouveau.geo.XYEncodingUtils;
import org.apache.lucene.ars_nouveau.geo.XYGeometry;
import org.apache.lucene.ars_nouveau.geo.XYPolygon;
import org.apache.lucene.ars_nouveau.geo.XYRectangle;
import org.apache.lucene.ars_nouveau.index.DocValuesType;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.SortField;

public class XYDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public XYDocValuesField(String name, float x, float y) {
        super(name, TYPE);
        this.setLocationValue(x, y);
    }

    public void setLocationValue(float x, float y) {
        int xEncoded = XYEncodingUtils.encode(x);
        int yEncoded = XYEncodingUtils.encode(y);
        this.fieldsData = (long)xEncoded << 32 | (long)yEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + String.valueOf((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + String.valueOf((Object)TYPE.docValuesType()) + ", is the field really a XYDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(XYEncodingUtils.decode((int)(currentValue >> 32)));
        result.append(',');
        result.append(XYEncodingUtils.decode((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, float x, float y) {
        return new XYPointSortField(field, x, y);
    }

    public static Query newSlowBoxQuery(String field, float minX, float maxX, float minY, float maxY) {
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        return new XYDocValuesPointInGeometryQuery(field, rectangle);
    }

    public static Query newSlowDistanceQuery(String field, float x, float y, float radius) {
        XYCircle circle = new XYCircle(x, y, radius);
        return new XYDocValuesPointInGeometryQuery(field, circle);
    }

    public static Query newSlowPolygonQuery(String field, XYPolygon ... polygons) {
        return XYDocValuesField.newSlowGeometryQuery(field, polygons);
    }

    public static Query newSlowGeometryQuery(String field, XYGeometry ... geometries) {
        return new XYDocValuesPointInGeometryQuery(field, geometries);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

