/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.util;

import java.io.IOException;
import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.lucene.ars_nouveau.analysis.CharacterUtils;
import org.apache.lucene.ars_nouveau.analysis.Tokenizer;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.ars_nouveau.util.AttributeFactory;

public abstract class CharTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private int finalOffset = 0;
    public static final int DEFAULT_MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;
    private final int maxTokenLen;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final CharacterUtils.CharacterBuffer ioBuffer = CharacterUtils.newCharacterBuffer(4096);

    public CharTokenizer() {
        this.maxTokenLen = 255;
    }

    public CharTokenizer(AttributeFactory factory) {
        super(factory);
        this.maxTokenLen = 255;
    }

    public CharTokenizer(AttributeFactory factory, int maxTokenLen) {
        super(factory);
        if (maxTokenLen > 0x100000 || maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + maxTokenLen);
        }
        this.maxTokenLen = maxTokenLen;
    }

    public static CharTokenizer fromTokenCharPredicate(IntPredicate tokenCharPredicate) {
        return CharTokenizer.fromTokenCharPredicate(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, tokenCharPredicate);
    }

    public static CharTokenizer fromTokenCharPredicate(AttributeFactory factory, final IntPredicate tokenCharPredicate) {
        Objects.requireNonNull(tokenCharPredicate, "predicate must not be null.");
        return new CharTokenizer(factory){

            @Override
            protected boolean isTokenChar(int c) {
                return tokenCharPredicate.test(c);
            }
        };
    }

    public static CharTokenizer fromSeparatorCharPredicate(IntPredicate separatorCharPredicate) {
        return CharTokenizer.fromSeparatorCharPredicate(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, separatorCharPredicate);
    }

    public static CharTokenizer fromSeparatorCharPredicate(AttributeFactory factory, IntPredicate separatorCharPredicate) {
        return CharTokenizer.fromTokenCharPredicate(factory, separatorCharPredicate.negate());
    }

    protected abstract boolean isTokenChar(int var1);

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int length = 0;
        int start = -1;
        int end = -1;
        char[] buffer = this.termAtt.buffer();
        while (true) {
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                CharacterUtils.fill(this.ioBuffer, this.input);
                if (this.ioBuffer.getLength() == 0) {
                    this.dataLen = 0;
                    if (length <= 0) {
                        this.finalOffset = this.correctOffset(this.offset);
                        return false;
                    }
                    break;
                }
                this.dataLen = this.ioBuffer.getLength();
                this.bufferIndex = 0;
            }
            int c = Character.codePointAt(this.ioBuffer.getBuffer(), this.bufferIndex, this.ioBuffer.getLength());
            int charCount = Character.charCount(c);
            this.bufferIndex += charCount;
            if (this.isTokenChar(c)) {
                if (length == 0) {
                    assert (start == -1);
                    end = start = this.offset + this.bufferIndex - charCount;
                } else if (length >= buffer.length - 1) {
                    buffer = this.termAtt.resizeBuffer(2 + length);
                }
                end += charCount;
                if ((length += Character.toChars(c, buffer, length)) < this.maxTokenLen) continue;
                break;
            }
            if (length > 0) break;
        }
        this.termAtt.setLength(length);
        assert (start != -1);
        this.finalOffset = this.correctOffset(end);
        this.offsetAtt.setOffset(this.correctOffset(start), this.finalOffset);
        return true;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
        this.finalOffset = 0;
        this.ioBuffer.reset();
    }
}

