/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.sr;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.CharArraySet;
import org.apache.lucene.ars_nouveau.analysis.LowerCaseFilter;
import org.apache.lucene.ars_nouveau.analysis.StopFilter;
import org.apache.lucene.ars_nouveau.analysis.StopwordAnalyzerBase;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.WordlistLoader;
import org.apache.lucene.ars_nouveau.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.ars_nouveau.analysis.snowball.SnowballFilter;
import org.apache.lucene.ars_nouveau.analysis.sr.SerbianNormalizationFilter;
import org.apache.lucene.ars_nouveau.analysis.standard.StandardTokenizer;
import org.apache.lucene.ars_nouveau.util.IOUtils;
import org.tartarus.snowball.ext.SerbianStemmer;

public class SerbianAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SerbianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public SerbianAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public SerbianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SnowballFilter((TokenStream)result, new SerbianStemmer());
        result = new SerbianNormalizationFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(SerbianAnalyzer.class.getResourceAsStream(SerbianAnalyzer.DEFAULT_STOPWORD_FILE), SerbianAnalyzer.DEFAULT_STOPWORD_FILE), SerbianAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

