/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.ars_nouveau.analysis.TokenFilterFactory;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.miscellaneous.TruncateTokenFilter;

public class TruncateTokenFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "truncate";
    public static final String PREFIX_LENGTH_KEY = "prefixLength";
    private final int prefixLength;

    public TruncateTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.prefixLength = Integer.parseInt(this.get(args, PREFIX_LENGTH_KEY, "5"));
        if (this.prefixLength < 1) {
            throw new IllegalArgumentException("prefixLength parameter must be a positive number: " + this.prefixLength);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameter(s): " + String.valueOf(args));
        }
    }

    public TruncateTokenFilterFactory() {
        throw TruncateTokenFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new TruncateTokenFilter(input, this.prefixLength);
    }
}

