/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.hunspell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.ars_nouveau.analysis.hunspell.Dictionary;
import org.apache.lucene.ars_nouveau.analysis.hunspell.FragmentChecker;
import org.apache.lucene.ars_nouveau.analysis.hunspell.GeneratingSuggester;
import org.apache.lucene.ars_nouveau.analysis.hunspell.Hunspell;
import org.apache.lucene.ars_nouveau.analysis.hunspell.ModifyingSuggester;
import org.apache.lucene.ars_nouveau.analysis.hunspell.Root;
import org.apache.lucene.ars_nouveau.analysis.hunspell.SuggestibleEntryCache;
import org.apache.lucene.ars_nouveau.analysis.hunspell.Suggestion;
import org.apache.lucene.ars_nouveau.analysis.hunspell.SuggestionTimeoutException;
import org.apache.lucene.ars_nouveau.analysis.hunspell.TimeoutPolicy;
import org.apache.lucene.ars_nouveau.analysis.hunspell.WordCase;
import org.apache.lucene.ars_nouveau.analysis.hunspell.WordContext;
import org.apache.lucene.ars_nouveau.util.CharsRef;

public class Suggester {
    private final Dictionary dictionary;
    private final SuggestibleEntryCache suggestibleCache;
    private final FragmentChecker fragmentChecker;
    private final boolean proceedPastRep;

    public Suggester(Dictionary dictionary) {
        this(dictionary, null, FragmentChecker.EVERYTHING_POSSIBLE, false);
    }

    private Suggester(Dictionary dictionary, SuggestibleEntryCache suggestibleCache, FragmentChecker checker, boolean proceedPastRep) {
        this.dictionary = dictionary;
        this.suggestibleCache = suggestibleCache;
        this.fragmentChecker = checker;
        this.proceedPastRep = proceedPastRep;
    }

    public Suggester withSuggestibleEntryCache() {
        SuggestibleEntryCache cache = SuggestibleEntryCache.buildCache(this.dictionary.words);
        return new Suggester(this.dictionary, cache, this.fragmentChecker, this.proceedPastRep);
    }

    public Suggester withFragmentChecker(FragmentChecker checker) {
        return new Suggester(this.dictionary, this.suggestibleCache, checker, this.proceedPastRep);
    }

    public Suggester proceedPastRep() {
        return new Suggester(this.dictionary, this.suggestibleCache, this.fragmentChecker, true);
    }

    public List<String> suggestNoTimeout(String word, Runnable checkCanceled) {
        LinkedHashSet<Suggestion> suggestions = new LinkedHashSet<Suggestion>();
        return this.suggest(word, suggestions, this.handleCustomTimeoutException(checkCanceled, suggestions));
    }

    private Runnable handleCustomTimeoutException(Runnable checkCanceled, LinkedHashSet<Suggestion> suggestions) {
        return () -> {
            try {
                checkCanceled.run();
            }
            catch (SuggestionTimeoutException e) {
                if (e.getPartialResult() != null) {
                    throw e;
                }
                throw new SuggestionTimeoutException(e.getMessage(), this.postprocess(suggestions));
            }
        };
    }

    public List<String> suggestWithTimeout(String word, long timeLimitMs, Runnable checkCanceled) throws SuggestionTimeoutException {
        LinkedHashSet<Suggestion> suggestions = new LinkedHashSet<Suggestion>();
        Runnable checkTime = this.checkTimeLimit(word, suggestions, timeLimitMs, checkCanceled);
        return this.suggest(word, suggestions, this.handleCustomTimeoutException(checkTime, suggestions));
    }

    private List<String> suggest(String word, LinkedHashSet<Suggestion> suggestions, Runnable checkCanceled) throws SuggestionTimeoutException {
        String title;
        checkCanceled.run();
        if (word.length() >= 100) {
            return Collections.emptyList();
        }
        if (this.dictionary.needsInputCleaning(word)) {
            word = this.dictionary.cleanInput(word, new StringBuilder()).toString();
        }
        Hunspell suggestionSpeller = new Hunspell(this, this.dictionary, TimeoutPolicy.NO_TIMEOUT, checkCanceled){
            final Map<String, Optional<Root<CharsRef>>> compoundCache = new HashMap<String, Optional<Root<CharsRef>>>();

            @Override
            boolean acceptsStem(int formID) {
                return !this.dictionary.hasFlag(formID, this.dictionary.noSuggest) && !this.dictionary.hasFlag(formID, this.dictionary.subStandard);
            }

            @Override
            Root<CharsRef> findStem(char[] chars, int offset, int length, WordCase originalCase, WordContext context) {
                if (context == WordContext.COMPOUND_BEGIN && originalCase == null) {
                    return this.compoundCache.computeIfAbsent(new String(chars, offset, length), __ -> Optional.ofNullable(super.findStem(chars, offset, length, null, context))).orElse(null);
                }
                return super.findStem(chars, offset, length, originalCase, context);
            }
        };
        WordCase wordCase = WordCase.caseOf(word);
        if (this.dictionary.forceUCase != '\u0000' && wordCase == WordCase.LOWER && suggestionSpeller.spell(title = this.dictionary.toTitleCase(word))) {
            return Collections.singletonList(title);
        }
        boolean hasGoodSuggestions = new ModifyingSuggester(suggestionSpeller, suggestions, word, wordCase, this.fragmentChecker, this.proceedPastRep).suggest();
        if (!hasGoodSuggestions && this.dictionary.maxNGramSuggestions > 0) {
            List<String> generated = new GeneratingSuggester(suggestionSpeller, this.suggestibleCache).suggest(this.dictionary.toLowerCase(word), wordCase, suggestions);
            for (String raw : generated) {
                suggestions.add(new Suggestion(raw, word, wordCase, suggestionSpeller));
            }
        }
        if (word.contains("-") && suggestions.stream().noneMatch(s -> s.raw.contains("-"))) {
            for (String raw : this.modifyChunksBetweenDashes(word, suggestionSpeller, checkCanceled)) {
                suggestions.add(new Suggestion(raw, word, wordCase, suggestionSpeller));
            }
        }
        return this.postprocess(suggestions);
    }

    private Runnable checkTimeLimit(final String word, final Set<Suggestion> suggestions, final long timeLimitMs, final Runnable checkCanceled) {
        return new Runnable(){
            final long deadline;
            int invocationCounter;
            {
                this.deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeLimitMs);
                this.invocationCounter = 100;
            }

            @Override
            public void run() {
                checkCanceled.run();
                if (--this.invocationCounter <= 0) {
                    if (System.nanoTime() - this.deadline > 0L) {
                        this.stop();
                    }
                    this.invocationCounter = 100;
                }
            }

            private void stop() {
                String message = "Time limit of " + timeLimitMs + "ms exceeded for " + word;
                throw new SuggestionTimeoutException(message, Suggester.this.postprocess(suggestions));
            }
        };
    }

    private List<String> postprocess(Collection<Suggestion> suggestions) {
        return suggestions.stream().flatMap(s -> Arrays.stream(s.result)).distinct().toList();
    }

    private List<String> modifyChunksBetweenDashes(String word, Hunspell speller, Runnable checkCanceled) {
        ArrayList<String> result = new ArrayList<String>();
        int chunkStart = 0;
        while (chunkStart < word.length()) {
            String chunk;
            int chunkEnd = word.indexOf(45, chunkStart);
            if (chunkEnd < 0) {
                chunkEnd = word.length();
            }
            if (chunkEnd > chunkStart && !speller.spell(chunk = word.substring(chunkStart, chunkEnd))) {
                for (String chunkSug : this.suggestNoTimeout(chunk, checkCanceled)) {
                    String replaced = word.substring(0, chunkStart) + chunkSug + word.substring(chunkEnd);
                    if (!speller.spell(replaced)) continue;
                    result.add(replaced);
                }
            }
            chunkStart = chunkEnd + 1;
        }
        return result;
    }
}

