/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.Lily;
import com.hollingsworth.arsnouveau.common.entity.Nook;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.PacketSummonDog;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class PacketUnsummonDog
extends AbstractPacket {
    public PacketSummonDog.DogType dogType;
    public static final CustomPacketPayload.Type<PacketUnsummonDog> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("unsummon_dog"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUnsummonDog> CODEC = StreamCodec.ofMember(PacketUnsummonDog::toBytes, PacketUnsummonDog::new);

    public PacketUnsummonDog(PacketSummonDog.DogType dogType) {
        this.dogType = dogType;
    }

    public PacketUnsummonDog(RegistryFriendlyByteBuf buf) {
        this.dogType = (PacketSummonDog.DogType)buf.readEnum(PacketSummonDog.DogType.class);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.dogType);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (this.dogType == PacketSummonDog.DogType.NOOK) {
            Nook nook;
            ServerLevel level = (ServerLevel)player.level();
            UUID nookUuid = (UUID)Nook.ownerNookMap.get((Object)player.getUUID());
            if (nookUuid != null && (nook = (Nook)level.getEntity(nookUuid)) != null) {
                nook.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            Lily lily;
            ServerLevel level = (ServerLevel)player.level();
            UUID lilyUuid = (UUID)Lily.ownerLilyMap.get((Object)player.getUUID());
            if (lilyUuid != null && (lily = (Lily)level.getEntity(lilyUuid)) != null) {
                lily.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

