/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PacketToggleLight
extends AbstractPacket {
    boolean enabled;
    public static final CustomPacketPayload.Type<PacketToggleLight> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("toggle_light"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketToggleLight> CODEC = StreamCodec.ofMember(PacketToggleLight::toBytes, PacketToggleLight::new);

    public PacketToggleLight(RegistryFriendlyByteBuf buf) {
        this.enabled = buf.readBoolean();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.enabled);
    }

    public PacketToggleLight(boolean stack) {
        this.enabled = stack;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        LightManager.toggleLightsAndConfig(this.enabled);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

