/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketQuickCast
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketQuickCast> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("quick_cast"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketQuickCast> CODEC = StreamCodec.ofMember(PacketQuickCast::toBytes, PacketQuickCast::new);
    int slot;
    float xRot;
    float yRot;

    public PacketQuickCast(int slot) {
        Entity cam = Minecraft.getInstance().cameraEntity;
        this.slot = slot;
        this.xRot = cam.xRot;
        this.yRot = cam.yRot;
    }

    public PacketQuickCast(int slot, float xRot, float yRot) {
        this.slot = slot;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public PacketQuickCast(RegistryFriendlyByteBuf buf) {
        this.slot = buf.readInt();
        this.xRot = buf.readFloat();
        this.yRot = buf.readFloat();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeFloat(this.xRot);
        buf.writeFloat(this.yRot);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        InteractionHand hand = StackUtil.getQuickCaster((Player)player);
        if (hand == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof ISpellHotkeyListener)) {
            return;
        }
        ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)item;
        float pXRot = player.xRot;
        float pYRot = player.yRot;
        player.setXRot(this.xRot);
        player.setYHeadRot(this.yRot);
        hotkeyListener.onQuickCast(stack, player, hand, this.slot);
        player.setXRot(pXRot);
        player.setYHeadRot(pYRot);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

