/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin;

import com.hollingsworth.arsnouveau.api.event.EntityPreRemovalEvent;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.common.entity.BubbleEntity;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public Level level;

    @Shadow
    public abstract boolean isCurrentlyGlowing();

    @ModifyReturnValue(method={"isInWaterOrRain"}, at={@At(value="RETURN")})
    private boolean ars_nouveau$isInWaterOrRain(boolean original) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && EntityMixin.isWet(livingEntity = (LivingEntity)entity)) {
            return true;
        }
        return original;
    }

    @Inject(method={"setRemainingFireTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void ars_nouveau$setSecondsOnFire(int pRemainingFireTicks, CallbackInfo ci) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && EntityMixin.isWet(livingEntity = (LivingEntity)entity) && pRemainingFireTicks > 0) {
            livingEntity.clearFire();
            ci.cancel();
        }
    }

    @Inject(method={"setRemoved"}, at={@At(value="HEAD")})
    private void onRemoval(Entity.RemovalReason removalReason, CallbackInfo ci) {
        NeoForge.EVENT_BUS.post((Event)new EntityPreRemovalEvent(this.level, (Entity)this));
    }

    private static boolean isWet(LivingEntity livingEntity) {
        return livingEntity.hasEffect(ModPotions.SOAKED_EFFECT) || livingEntity.getVehicle() instanceof BubbleEntity;
    }

    @Inject(method={"getTeamColor"}, at={@At(value="RETURN")}, cancellable=true)
    public void ars_nouveau$getTeamColor(CallbackInfoReturnable<Integer> cir) {
        LivingEntity livingEntity;
        CompoundTag perData;
        EntityMixin entityMixin;
        int color = (Integer)cir.getReturnValue();
        if (color == 0xFFFFFF && this.isCurrentlyGlowing() && (entityMixin = this) instanceof LivingEntity && (perData = (livingEntity = (LivingEntity)entityMixin).getPersistentData()).contains("ars_nouveau:glow_color")) {
            color = perData.getInt("ars_nouveau:glow_color");
            if (color < 0) {
                color = Color.rainbowColor(ClientInfo.ticksInGame).getRGB();
            }
            cir.setReturnValue((Object)color);
        }
    }

    @WrapMethod(method={"getGravity"})
    public double wrapGravity(Operation<Double> original) {
        return (Double)original.call(new Object[0]);
    }
}

