/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.neoforged.neoforge.common.util.FakePlayer;

public class OpenChestEvent
implements ITimedEvent {
    ServerLevel level;
    public int duration;
    public BlockPos pos;
    FakePlayer fakePlayer;

    public OpenChestEvent(ServerLevel level, BlockPos pos, int duration) {
        this.duration = duration;
        this.level = level;
        this.pos = pos;
        this.fakePlayer = ANFakePlayer.getPlayer(level);
    }

    public void open() {
        try {
            BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                this.fakePlayer.level = this.level;
                this.fakePlayer.containerCounter = this.fakePlayer.containerCounter % 100 + 1;
                this.fakePlayer.setPos((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5);
                this.fakePlayer.containerMenu = chestBlockEntity.createMenu(this.fakePlayer.containerCounter, this.fakePlayer.inventory, (Player)this.fakePlayer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void attemptClose() {
        try {
            if (this.level.getBlockEntity(this.pos) instanceof ChestBlockEntity) {
                this.fakePlayer.level = this.level;
                this.fakePlayer.setPos((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5);
                this.fakePlayer.containerMenu = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (this.duration <= 0) {
            this.attemptClose();
        }
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0;
    }
}

