/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs;

import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.ChunkCache;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.ModNode;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathPointExtended;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathResult;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingConstants;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingOptions;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.SurfaceType;
import com.hollingsworth.arsnouveau.common.util.Log;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path> {
    public static boolean DEBUG_DRAW = false;
    public static Set<ModNode> lastDebugNodesVisited;
    public static Set<ModNode> lastDebugNodesNotVisited;
    public static Set<ModNode> lastDebugNodesPath;
    public static final Map<Player, UUID> trackingMap;
    protected final BlockPos start;
    protected final LevelReader world;
    protected final PathResult result;
    protected final int maxRange;
    public Queue<ModNode> nodesOpen = new PriorityQueue<ModNode>(500);
    public Map<Integer, ModNode> nodesVisited = new HashMap<Integer, ModNode>();
    protected boolean debugDrawEnabled = false;
    @Nullable
    protected Set<ModNode> debugNodesVisited = new HashSet<ModNode>();
    @Nullable
    protected Set<ModNode> debugNodesNotVisited = new HashSet<ModNode>();
    @Nullable
    protected Set<ModNode> debugNodesPath = new HashSet<ModNode>();
    private final boolean allowJumpPointSearchTypeWalk;
    private int totalNodesAdded = 0;
    public int totalNodesVisited = 0;
    private final boolean xzRestricted;
    private final boolean hardXzRestriction;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    private int maxY;
    private int minY;
    private final AbstractAdvancedPathNavigate.RestrictionType restrictionType;
    protected WeakReference<LivingEntity> entity;

    public AbstractPathJob(Level world, BlockPos start, BlockPos end, int range, LivingEntity entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos end, int range, PathResult result, LivingEntity entity) {
        int minX = Math.min(start.getX(), end.getX()) - range / 2;
        int minZ = Math.min(start.getZ(), end.getZ()) - range / 2;
        int maxX = Math.max(start.getX(), end.getX()) + range / 2;
        int maxZ = Math.max(start.getZ(), end.getZ()) + range / 2;
        this.restrictionType = AbstractAdvancedPathNavigate.RestrictionType.NONE;
        this.xzRestricted = false;
        this.hardXzRestriction = false;
        this.world = new ChunkCache(world, new BlockPos(minX, world.getMinBuildHeight(), minZ), new BlockPos(maxX, world.getMaxBuildHeight(), maxZ), range, world.dimensionType());
        this.start = new BlockPos((Vec3i)start);
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (DEBUG_DRAW) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<ModNode>();
            this.debugNodesNotVisited = new HashSet<ModNode>();
            this.debugNodesPath = new HashSet<ModNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, boolean hardRestriction, PathResult<AbstractPathJob> result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this(world, start, startRestriction, endRestriction, range, Vec3i.ZERO, hardRestriction, result, entity, restrictionType);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, Vec3i grow, boolean hardRestriction, PathResult<AbstractPathJob> result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this.minX = Math.min(startRestriction.getX(), endRestriction.getX()) - grow.getX();
        this.minZ = Math.min(startRestriction.getZ(), endRestriction.getZ()) - grow.getZ();
        this.maxX = Math.max(startRestriction.getX(), endRestriction.getX()) + grow.getX();
        this.maxZ = Math.max(startRestriction.getZ(), endRestriction.getZ()) + grow.getZ();
        this.minY = Math.min(startRestriction.getY(), endRestriction.getY()) - grow.getY();
        this.maxY = Math.max(startRestriction.getY(), endRestriction.getY()) + grow.getY();
        this.xzRestricted = true;
        this.hardXzRestriction = hardRestriction;
        this.restrictionType = restrictionType;
        this.world = new ChunkCache(world, new BlockPos(this.minX, world.getMinBuildHeight(), this.minZ), new BlockPos(this.maxX, world.getMaxBuildHeight(), this.maxZ), range, world.dimensionType());
        this.start = start;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (DEBUG_DRAW) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<ModNode>();
            this.debugNodesNotVisited = new HashSet<ModNode>();
            this.debugNodesPath = new HashSet<ModNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    protected boolean onLadderGoingUp(ModNode currentNode, BlockPos dPos) {
        return currentNode.isLadder() && (dPos.getY() >= 0 || dPos.getX() != 0 || dPos.getZ() != 0);
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.floor((double)entity.getX()), Mth.floor((double)entity.getY()), Mth.floor((double)entity.getZ()));
        Level level = entity.level;
        BlockState bs = level.getBlockState((BlockPos)pos);
        VoxelShape collisionShape = bs.getCollisionShape((BlockGetter)level, (BlockPos)pos);
        boolean isFineToStandIn = AbstractPathJob.canStandInSolidBlock(bs);
        if (bs.blocksMotion() && !isFineToStandIn && collisionShape.max(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.getX() % 1.0);
            double relPosZ = Math.abs(entity.getZ() % 1.0);
            for (AABB box : collisionShape.toAabbs()) {
                if (!(relPosX >= box.minX) || !(relPosX <= box.maxX) || !(relPosZ >= box.minZ) || !(relPosZ <= box.maxZ) || !(box.maxY > 0.0)) continue;
                pos.set(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = level.getBlockState((BlockPos)pos);
                break;
            }
        }
        BlockState down = level.getBlockState(pos.below());
        while (AbstractPathJob.canStandInSolidBlock(bs) && AbstractPathJob.canStandInSolidBlock(down) && !down.getBlock().isLadder(down, (LevelReader)level, pos.below(), entity) && down.getFluidState().isEmpty()) {
            pos.move(Direction.DOWN, 1);
            bs = down;
            down = level.getBlockState(pos.below());
            if (pos.getY() >= entity.getCommandSenderWorld().getMinBuildHeight()) continue;
            return entity.blockPosition();
        }
        Block b = bs.getBlock();
        if (entity.isInWater()) {
            while (!bs.getFluidState().isEmpty()) {
                pos.set(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = level.getBlockState((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || bs.isSolid() && !AbstractPathJob.canStandInSolidBlock(bs)) {
            double dX = entity.getX() - Math.floor(entity.getX());
            double dZ = entity.getZ() - Math.floor(entity.getZ());
            if (dX < 0.5 && dZ < 0.5) {
                if (dZ < dX) {
                    pos.set(pos.getX(), pos.getY(), pos.getZ() - 1);
                } else {
                    pos.set(pos.getX() - 1, pos.getY(), pos.getZ());
                }
            } else if (dZ > dX) {
                pos.set(pos.getX(), pos.getY(), pos.getZ() + 1);
            } else {
                pos.set(pos.getX() + 1, pos.getY(), pos.getZ());
            }
        }
        return pos.immutable();
    }

    private static void setLadderFacing(LevelReader world, BlockPos pos, PathPointExtended p) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof VineBlock) {
            if (((Boolean)state.getValue((Property)VineBlock.SOUTH)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.getValue((Property)VineBlock.WEST)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.getValue((Property)VineBlock.NORTH)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.getValue((Property)VineBlock.EAST)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.getValue((Property)LadderBlock.FACING));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    private static boolean canStandInSolidBlock(BlockState state) {
        return state.getBlock() instanceof DoorBlock || state.getBlock() instanceof TrapDoorBlock || !state.getBlock().properties.hasCollision;
    }

    private static boolean onALadder(ModNode node, ModNode nextInPath, BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.getX() == pos.getX() && nextInPath.pos.getZ() == pos.getZ();
    }

    private static int computeNodeKey(BlockPos pos) {
        return (pos.getX() & 0xFFF) << 20 | (pos.getY() & 0xFF) << 12 | pos.getZ() & 0xFFF;
    }

    protected double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockState state, BlockPos blockPos) {
        double cost = Math.sqrt(dPos.getX() * dPos.getX() + dPos.getY() * dPos.getY() + dPos.getZ() * dPos.getZ());
        if (!(dPos.getY() == 0 || Math.abs(dPos.getY()) <= 1 && this.world.getBlockState(blockPos).getBlock() instanceof StairBlock)) {
            cost = dPos.getY() > 0 ? (cost *= this.pathingOptions.jumpCost * (double)Math.abs(dPos.getY())) : (cost *= this.pathingOptions.dropCost * (double)Math.abs(dPos.getY()));
        }
        if (this.world.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.OPEN)) {
            cost *= this.pathingOptions.traverseToggleAbleCost;
        }
        if (onPath) {
            cost *= this.pathingOptions.onPathCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (state.getBlock() instanceof VineBlock) {
            cost *= this.pathingOptions.vineCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost *= this.pathingOptions.swimCostEnter) : (cost *= this.pathingOptions.swimCost);
        }
        return cost;
    }

    private static boolean nodeClosed(ModNode node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(LevelReader world, BlockPos pos, ModNode node) {
        return node == null ? SurfaceType.isWater((BlockGetter)world, pos.below()) : node.isSwimming();
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Path search() {
        ModNode bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            boolean isViablePosition;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            ModNode currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            currentNode.setClosed();
            boolean bl = isViablePosition = this.isInRestrictedArea(currentNode.pos) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.getBlockState(currentNode.pos.below()), currentNode.pos.below()) == SurfaceType.WALKABLE;
            if (isViablePosition && this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (isViablePosition && nodeResultScore < bestNodeResultScore && !currentNode.isCornerNode()) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.hardXzRestriction && !isViablePosition) continue;
            this.walkCurrentNode(currentNode);
        }
        @NotNull Path path = this.finalizePath(bestNode);
        return path;
    }

    private void handleDebugOptions(ModNode currentNode) {
        if (this.debugDrawEnabled && this.debugNodesNotVisited != null && this.debugNodesVisited != null && currentNode != null) {
            this.addNodeToDebug(currentNode);
        }
    }

    private void addNodeToDebug(ModNode currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(ModNode node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(@NotNull ModNode currentNode) {
        BlockPos dPos = PathingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.subtract((Vec3i)currentNode.parent.pos);
        }
        if (this.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if ((currentNode.parent == null || !currentNode.parent.pos.equals((Object)currentNode.pos.below())) && currentNode.isCornerNode()) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
            return;
        }
        if (this.isPassable(currentNode.pos.below(), false, currentNode.parent) && !currentNode.isSwimming() && this.isLiquid(this.world.getBlockState(currentNode.pos.below()))) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.getZ() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.getX() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_EAST);
        }
        if (dPos.getZ() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.getX() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_WEST);
        }
    }

    protected boolean onLadderGoingDown(ModNode currentNode, BlockPos dPos) {
        return (dPos.getY() <= 0 || dPos.getX() != 0 || dPos.getZ() != 0) && this.isLadder(currentNode.pos.below());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugDraw() {
        if (this.debugDrawEnabled) {
            Object object = PathingConstants.debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = this.debugNodesNotVisited;
                lastDebugNodesVisited = this.debugNodesVisited;
                lastDebugNodesPath = this.debugNodesPath;
            }
        }
    }

    private ModNode getAndSetupStartNode() {
        @NotNull ModNode startNode = new ModNode(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.isLiquid(this.world.getBlockState(this.start.below()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.getBlockState(this.start).getBlock() instanceof BaseRailBlock);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    public boolean isLiquid(BlockState state) {
        return state.liquid() || !state.blocksMotion() && !state.getFluidState().isEmpty();
    }

    private Path finalizePath(ModNode targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        ModNode node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        @NotNull Node[] points = new Node[pathLength];
        points[0] = new PathPointExtended(node.pos);
        if (this.debugDrawEnabled) {
            this.addPathNodeToDebug(node);
        }
        ModNode nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            @NotNull BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.offset((Vec3i)PathingConstants.BLOCKPOS_DOWN);
            }
            @NotNull PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= 8) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.getY() > pos.getY()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            if (next != null) {
                next.cameFrom = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    private void doDebugPrinting(Node[] points) {
    }

    protected BlockPos getPathTargetPos(ModNode finalNode) {
        return finalNode.pos;
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(ModNode var1);

    protected abstract double getNodeResultScore(ModNode var1);

    protected final boolean walk(ModNode parent, BlockPos dPos) {
        int nodeKey;
        ModNode node;
        BlockPos pos = parent.pos.offset((Vec3i)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < this.world.getMinBuildHeight()) {
            return false;
        }
        boolean corner = false;
        if (pos.getY() != newY) {
            if (parent.isCornerNode() && (dPos.getX() != 0 || dPos.getZ() != 0)) {
                return false;
            }
            if (!(parent.isCornerNode() || newY - parent.pos.getY() <= 0 || parent.parent != null && parent.parent.pos.equals((Object)parent.pos.offset((Vec3i)new BlockPos(0, newY - pos.getY(), 0))))) {
                dPos = new BlockPos(0, newY - pos.getY(), 0);
                pos = parent.pos.offset((Vec3i)dPos);
                corner = true;
            } else if (!(parent.isCornerNode() || newY - parent.pos.getY() >= 0 || dPos.getX() == 0 && dPos.getZ() == 0 || parent.parent != null && parent.pos.below().equals((Object)parent.parent.pos))) {
                dPos = new BlockPos(dPos.getX(), 0, dPos.getZ());
                pos = parent.pos.offset((Vec3i)dPos);
                corner = true;
            } else {
                dPos = dPos.offset(0, newY - pos.getY(), 0);
                pos = new BlockPos(pos.getX(), newY, pos.getZ());
            }
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return false;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        BlockState state = this.world.getBlockState(pos);
        boolean onRoad = this.pathingOptions.getIsRoad().apply(this.world.getBlockState(pos.below()));
        boolean onRails = this.pathingOptions.canUseRails() && this.world.getBlockState(corner ? pos.below() : pos).getBlock() instanceof BaseRailBlock;
        boolean railsExit = !onRails && parent != null && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, onRoad, onRails, railsExit, swimStart, corner, state, pos);
        stepCost = this.calcAdditionalCost(stepCost, parent, pos, state);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
            node.setCornerNode(corner);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        BlockEntity blockEntity = this.world.getBlockEntity(pos);
        if (blockEntity instanceof PortalTile) {
            PortalTile portal = (PortalTile)blockEntity;
            if (portal.dimID != null && portal.dimID.equals(portal.getLevel().dimension().location().toString())) {
                BlockPos warpPos = portal.warpPos;
                double portalHeuristic = this.computeHeuristic(warpPos);
                double portalCost = node.getCost();
                double portalScore = cost + heuristic;
                ModNode portalNode = this.createNode(node, warpPos, nodeKey, isSwimming, portalHeuristic, portalCost, portalScore);
                this.nodesOpen.offer(portalNode);
            }
        }
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    protected double calcAdditionalCost(double stepCost, ModNode parent, BlockPos pos, BlockState state) {
        return stepCost;
    }

    private void performJumpPointSearch(ModNode parent, BlockPos dPos, ModNode node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    private ModNode createNode(ModNode parent, BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        ModNode node = new ModNode(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        }
        if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(ModNode parent, ModNode node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(ModNode parent, BlockPos pos) {
        if (this.isLiquid(this.world.getBlockState(pos.above()))) {
            return -100;
        }
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.above(), this.world.getBlockState(pos.above()));
        }
        BlockState target = this.world.getBlockState(pos);
        if (!this.isPassable(target, pos, parent, false)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        BlockState below = this.world.getBlockState(pos.below());
        SurfaceType walkability = SurfaceType.getSurfaceType((BlockGetter)this.world, below, pos);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.getY();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -100;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(ModNode parent, BlockPos pos, BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (this.isLiquid(below)) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.getBlock(), pos.below())) {
            return pos.getY();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(ModNode parent, BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || (parent.pos.getX() != pos.getX() || parent.pos.getZ() != pos.getZ()) && this.isPassable(parent.pos.below(), false, parent) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.getBlockState(parent.pos.below()), parent.pos.below()) == SurfaceType.DROPABLE) {
            return -100;
        }
        for (int i = 2; i <= 10; ++i) {
            BlockState below = this.world.getBlockState(pos.below(i));
            if (SurfaceType.getSurfaceType((BlockGetter)this.world, below, pos) == SurfaceType.WALKABLE && i <= 3 || this.isLiquid(below)) {
                return pos.getY() - i + 1;
            }
            if (below.isAir()) continue;
            return -100;
        }
        return -100;
    }

    private int handleInLiquid(BlockPos pos, BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.getY();
        }
        if (this.pathingOptions.canSwim() && SurfaceType.isWater((BlockGetter)this.world, pos.below())) {
            return pos.getY();
        }
        return -100;
    }

    private int handleTargetNotPassable(ModNode parent, BlockPos pos, BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        int headSpace;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || SurfaceType.getSurfaceType((BlockGetter)this.world, target, pos) != SurfaceType.WALKABLE) {
            return -100;
        }
        boolean isSmall = this.pathingOptions.canFitInOneCube();
        int n = headSpace = isSmall ? 1 : 2;
        if (!this.isPassable(pos.above(headSpace), false, parent)) {
            bb1 = this.world.getBlockState(pos).getCollisionShape((BlockGetter)this.world, pos);
            bb2 = this.world.getBlockState(pos.above(headSpace)).getCollisionShape((BlockGetter)this.world, pos.above(headSpace));
            if ((double)pos.above(headSpace).getY() + this.getStartY(bb2, 1) - ((double)pos.getY() + this.getEndY(bb1, 0)) < (double)headSpace) {
                return -100;
            }
        }
        if (!this.canLeaveBlock(pos.above(headSpace), parent, true)) {
            return -100;
        }
        if (!this.isPassable(parent.pos.above(headSpace), false, parent)) {
            bb1 = this.world.getBlockState(pos).getCollisionShape((BlockGetter)this.world, pos);
            bb2 = this.world.getBlockState(parent.pos.above(headSpace)).getCollisionShape((BlockGetter)this.world, parent.pos.above(headSpace));
            if ((double)parent.pos.above(headSpace).getY() + this.getStartY(bb2, 1) - ((double)pos.getY() + this.getEndY(bb1, 0)) < (double)headSpace) {
                return -100;
            }
        }
        BlockState parentBelow = this.world.getBlockState(parent.pos.below());
        VoxelShape parentBB = parentBelow.getCollisionShape((BlockGetter)this.world, parent.pos.below());
        double parentY = parentBB.max(Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.pos.below().getY();
        double targetMaxY = target.getCollisionShape((BlockGetter)this.world, pos).max(Direction.Axis.Y) + (double)pos.getY();
        if (targetMaxY - parentMaxY < 1.3) {
            return pos.getY() + 1;
        }
        if (target.getBlock() instanceof StairBlock && parentY - 0.5 < 1.3 && target.getValue((Property)StairBlock.HALF) == Half.BOTTOM && AbstractPathJob.getXZFacing(parent.pos, pos) == target.getValue((Property)StairBlock.FACING)) {
            return pos.getY() + 1;
        }
        return -100;
    }

    public static Direction getXZFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.subtract((Vec3i)pos);
        return Direction.getNearest((float)vector.getX(), (float)0.0f, (float)vector.getZ());
    }

    private boolean checkHeadBlock(ModNode parent, BlockPos pos) {
        boolean isSmall;
        BlockPos localPos = pos;
        VoxelShape bb = this.world.getBlockState(localPos).getCollisionShape((BlockGetter)this.world, localPos);
        if (bb.max(Direction.Axis.Y) < 1.0) {
            localPos = pos.above();
        }
        if ((isSmall = this.pathingOptions.canFitInOneCube()) ? !this.isPassable(pos, true, parent) : !this.isPassable(pos.above(), true, parent)) {
            VoxelShape bb1 = this.world.getBlockState(pos.below()).getCollisionShape((BlockGetter)this.world, pos.below());
            VoxelShape bb2 = this.world.getBlockState(pos.above()).getCollisionShape((BlockGetter)this.world, pos.above());
            if ((double)pos.above().getY() + this.getStartY(bb2, 1) - ((double)pos.below().getY() + this.getEndY(bb1, 0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.world.getBlockState(parent.pos.below()).getCollisionShape((BlockGetter)this.world, pos.below());
                if ((double)pos.above().getY() + this.getStartY(bb2, 1) - ((double)parent.pos.below().getY() + this.getEndY(bb3, 0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockPos posAbove = isSmall ? pos : pos.above();
            BlockState hereState = this.world.getBlockState(localPos.below());
            VoxelShape bb1 = this.world.getBlockState(pos).getCollisionShape((BlockGetter)this.world, pos);
            VoxelShape bb2 = this.world.getBlockState(posAbove).getCollisionShape((BlockGetter)this.world, posAbove);
            if ((double)posAbove.getY() + this.getStartY(bb2, 1) - ((double)pos.getY() + this.getEndY(bb1, 0)) >= 2.0) {
                return false;
            }
            return this.isLiquid(hereState) && !this.isPassable(pos, false, parent);
        }
        return false;
    }

    private double getStartY(VoxelShape bb, int def) {
        return bb.isEmpty() ? (double)def : bb.min(Direction.Axis.Y);
    }

    private double getEndY(VoxelShape bb, int def) {
        return bb.isEmpty() ? (double)def : bb.max(Direction.Axis.Y);
    }

    protected boolean isPassable(BlockState block, BlockPos pos, ModNode parent, boolean head) {
        if (!this.canLeaveBlock(pos, parent, head)) {
            return false;
        }
        if (!block.isAir()) {
            VoxelShape shape = block.getCollisionShape((BlockGetter)this.world, pos);
            if (block.blocksMotion() && !shape.isEmpty() && !(shape.max(Direction.Axis.Y) <= 0.1)) {
                if (block.getBlock() instanceof TrapDoorBlock) {
                    Direction facing;
                    BlockPos dir;
                    BlockPos parentPos;
                    BlockPos blockPos = parentPos = parent == null ? this.start : parent.pos;
                    if (head) {
                        parentPos = parentPos.above();
                    }
                    if ((dir = pos.subtract((Vec3i)parentPos)).getY() != 0 && dir.getX() == 0 && dir.getZ() == 0) {
                        return true;
                    }
                    Direction direction = AbstractPathJob.getXZFacing(parentPos, pos);
                    if (direction == (facing = (Direction)block.getValue((Property)TrapDoorBlock.FACING)).getOpposite()) {
                        return true;
                    }
                    return direction != facing;
                }
                return this.pathingOptions.canEnterDoors() && (block.getBlock() instanceof DoorBlock || block.getBlock() instanceof FenceGateBlock) || block.getBlock() instanceof PressurePlateBlock || block.getBlock() instanceof SignBlock || block.getBlock() instanceof AbstractBannerBlock || !block.getBlock().properties.hasCollision;
            }
            if (block.getBlock() instanceof FireBlock || block.getBlock() instanceof SweetBerryBushBlock || block.getBlock() instanceof PowderSnowBlock) {
                return false;
            }
            if (this.isLadder(block.getBlock(), pos)) {
                return true;
            }
            if (shape.isEmpty() || shape.max(Direction.Axis.Y) <= 0.1 && !this.isLiquid(block) && (block.getBlock() != Blocks.SNOW || (Integer)block.getValue((Property)SnowLayerBlock.LAYERS) == 1)) {
                PathType pathType = block.getBlockPathType((BlockGetter)this.world, pos, (Mob)this.entity.get());
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean canLeaveBlock(BlockPos pos, ModNode parent, boolean head) {
        BlockState parentBlock;
        BlockPos parentPos;
        BlockPos blockPos = parentPos = parent == null ? this.start : parent.pos;
        if (head) {
            parentPos = parentPos.above();
        }
        if ((parentBlock = this.world.getBlockState(parentPos)).getBlock() instanceof TrapDoorBlock) {
            Direction facing;
            Direction direction;
            BlockPos dir = pos.subtract((Vec3i)parentPos);
            if (!((Boolean)parentBlock.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
                if (dir.getY() != 0) {
                    return head && parentBlock.getValue((Property)TrapDoorBlock.HALF) == Half.TOP && dir.getY() < 0 || !head && parentBlock.getValue((Property)TrapDoorBlock.HALF) == Half.BOTTOM && dir.getY() > 0;
                }
                return true;
            }
            if ((dir.getX() != 0 || dir.getZ() != 0) && (direction = AbstractPathJob.getXZFacing(parentPos, pos)) == (facing = (Direction)parentBlock.getValue((Property)TrapDoorBlock.FACING)).getOpposite()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos, boolean head, ModNode parent) {
        BlockState state = this.world.getBlockState(pos);
        VoxelShape shape = state.getCollisionShape((BlockGetter)this.world, pos);
        if (shape.isEmpty() || shape.max(Direction.Axis.Y) <= 0.1) {
            return !head || !(state.getBlock() instanceof WoolCarpetBlock) || this.isLadder(state.getBlock(), pos);
        }
        return this.isPassable(state, pos, parent, head);
    }

    protected boolean isLadder(Block block, BlockPos pos) {
        return block.isLadder(this.world.getBlockState(pos), this.world, pos, (LivingEntity)this.entity.get()) && (block != Blocks.VINE || this.pathingOptions.canClimbVines());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.getBlockState(pos).getBlock(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions = pathingOptions;
    }

    public boolean isInRestrictedArea(BlockPos pos) {
        boolean isInXZ;
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.NONE) {
            return true;
        }
        boolean bl = isInXZ = pos.getX() <= this.maxX && pos.getZ() <= this.maxZ && pos.getZ() >= this.minZ && pos.getX() >= this.minX;
        if (!isInXZ) {
            return false;
        }
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.XZ) {
            return true;
        }
        return pos.getY() <= this.maxY && pos.getY() >= this.minY;
    }

    public void synchToClient(LivingEntity mob) {
    }

    public static void synchToClient(HashSet<BlockPos> reached, Mob mob) {
    }

    static {
        trackingMap = new HashMap<Player, UUID>();
    }
}

