/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public abstract class GoToPosGoal<T extends StarbyBehavior>
extends ExtendedRangeGoal {
    public Starbuncle starbuncle;
    public T behavior;
    Supplier<Boolean> canUse;
    Supplier<Boolean> canContinue;
    public boolean isDone;
    public BlockPos targetPos;

    public GoToPosGoal(Starbuncle starbuncle, T behavior, Supplier<Boolean> canUse, Supplier<Boolean> canContinue) {
        super(30);
        this.starbuncle = starbuncle;
        this.behavior = behavior;
        this.canUse = canUse;
        this.canContinue = canContinue;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public GoToPosGoal(Starbuncle starbuncle, T behavior, Supplier<Boolean> canUse) {
        this(starbuncle, behavior, canUse, canUse);
    }

    @Override
    public void stop() {
        super.stop();
        this.isDone = false;
        this.targetPos = null;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    @Override
    public void start() {
        super.start();
        this.isDone = false;
        this.targetPos = this.getDestination();
        if (this.targetPos == null) {
            this.starbuncle.setBackOff(60 + this.starbuncle.level.random.nextInt(60));
            return;
        }
        this.starbuncle.addGoalDebug(this, new DebugEvent("StartedGoal", "Started goal "));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.targetPos == null) {
            return;
        }
        if (this.ticksRunning % 100 == 0 && !this.isDestinationStillValid(this.targetPos)) {
            this.starbuncle.addDebugEvent(new DebugEvent("became_invalid", "Invalid position " + this.targetPos.toString()));
            this.isDone = true;
            return;
        }
        Vec3 vec3 = new Vec3((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5);
        if (BlockUtil.distanceFrom(this.starbuncle.position().add(0.0, 0.5, 0.0), vec3) <= 2.5 + this.extendedRange && this.isDestinationStillValid(this.targetPos)) {
            this.isDone = this.onDestinationReached();
            return;
        }
        if (this.targetPos != null) {
            this.setPath(this.targetPos);
        }
    }

    @Override
    public boolean canUse() {
        return this.canUse.get() != false && this.starbuncle.getBackOff() <= 0;
    }

    public boolean canContinueToUse() {
        return this.targetPos != null && !this.isDone && this.canContinue.get() != false;
    }

    public void setPath(BlockPos pos) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(pos, 1.3);
        this.starbuncle.addGoalDebug(this, new DebugEvent("path_set", "path set to " + this.targetPos.toString()));
        if (this.starbuncle.getNavigation().getPath() != null && !this.starbuncle.getNavigation().getPath().canReach()) {
            this.isDone = true;
            this.starbuncle.addGoalDebug(this, new DebugEvent("unreachable", this.targetPos.toString()));
        }
    }

    @Nullable
    public abstract BlockPos getDestination();

    public abstract boolean onDestinationReached();

    public boolean isDestinationStillValid(BlockPos pos) {
        return true;
    }
}

