/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.ENCHANTMENT, EnchantmentProvider::bootstrap);

    public static void bootstrap(BootstrapContext<Enchantment> ctx) {
        HolderGetter holdergetter2 = ctx.lookup(Registries.ITEM);
        EnchantmentProvider.register(ctx, EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)holdergetter2.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ArsNouveau.prefix("enchantment.max_mana"), PerkAttributes.MAX_MANA, (LevelBasedValue)LevelBasedValue.perLevel((float)25.0f), AttributeModifier.Operation.ADD_VALUE)));
        EnchantmentProvider.register(ctx, EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)holdergetter2.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ArsNouveau.prefix("enchantment.mana_regen"), PerkAttributes.MANA_REGEN_BONUS, (LevelBasedValue)LevelBasedValue.perLevel((float)2.0f), AttributeModifier.Operation.ADD_VALUE)));
        EnchantmentProvider.register(ctx, EnchantmentRegistry.REACTIVE_ENCHANTMENT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)new AnyHolderSet(BuiltInRegistries.ITEM.asLookup()), (int)1, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})));
    }

    protected static void register(BootstrapContext<Enchantment> ctx, ResourceKey<Enchantment> enchantment, Enchantment.Builder builder) {
        ctx.register(enchantment, (Object)builder.build(enchantment.location()));
    }

    public EnchantmentProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("ars_nouveau"));
    }

    @NotNull
    public String getName() {
        return "Ars Nouveau's Enchantment Data";
    }

    public static HolderLookup.Provider createLookup() {
        RegistryAccess.Frozen frozen = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        return BUILDER.build((RegistryAccess)frozen);
    }

    public static class EnchantmentTagsProvider
    extends net.minecraft.data.tags.EnchantmentTagsProvider {
        public EnchantmentTagsProvider(PackOutput pPackOutput, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pPackOutput, provider, "ars_nouveau", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(EnchantmentTags.NON_TREASURE).addOptional(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT.location()).addOptional(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT.location());
            this.tag(EnchantmentTags.TRADEABLE).addOptional(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT.location()).addOptional(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT.location());
        }
    }
}

