/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.inv.FilterSet;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.IMapInventory;
import com.hollingsworth.arsnouveau.api.item.inv.SlotCache;
import com.hollingsworth.arsnouveau.common.block.tile.RepositoryCatalogTile;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RepositoryTile
extends RandomizableContainerBlockEntity
implements GeoBlockEntity,
ITooltipProvider,
IMapInventory {
    public static String[][] CONFIGURATIONS = new String[][]{{"1", "2_3", "4_6", "7_9", "10_12", "13_15", "16_18", "19_21", "22_24", "25_27"}, {"1", "2_3", "25_27", "22_24", "19_21", "10_12", "7_9", "4_6", "13_15", "16_18"}, {"10_12", "13_15", "7_9", "16_18", "4_6", "19_21", "2_3", "22_24", "1", "25_27"}, {"1", "2_3", "4_6", "13_15", "16_18", "25_27", "22_24", "10_12", "19_21", "7_9"}, {"1", "25_27", "2_3", "22_24", "4_6", "19_21", "7_9", "16_18", "10_12", "13_15"}, {"1", "2_3", "4_6", "10_12", "25_27", "22_24", "19_21", "13_15", "7_9", "16_18"}};
    private NonNullList<ItemStack> items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    public int fillLevel;
    public int configuration;
    public SlotCache slotCache = new SlotCache(false);
    public FilterSet filterSet = new FilterSet.ListSet();
    FilterableItemHandler filterableItemHandler;
    InvWrapper invWrapper = new InvWrapper((Container)this);
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void updateFill() {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.getContainerSize(); ++j) {
            ItemStack itemstack = this.getItem(j);
            if (itemstack.isEmpty()) continue;
            f += 1.0f;
            ++i;
        }
        int oldFill = this.fillLevel;
        this.fillLevel = Mth.floor((float)((f /= (float)this.getContainerSize()) * 14.0f)) + (i > 0 ? 1 : 0);
        if (oldFill != this.fillLevel) {
            this.updateBlock();
        }
    }

    public RepositoryTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.REPOSITORY_TILE.get(), pos, state);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItemStacks) {
        this.items = pItemStacks;
        this.initCache();
    }

    public void setItem(int pIndex, ItemStack pStack) {
        ItemStack oldItem = this.getItem(pIndex);
        super.setItem(pIndex, pStack);
        if (pStack.getItem() != oldItem.getItem()) {
            this.slotCache.replaceSlotWithItem(oldItem.getItem(), pStack.getItem(), pIndex);
        }
        this.updateFill();
    }

    public ItemStack removeItem(int pIndex, int pCount) {
        ItemStack extracted = super.removeItem(pIndex, pCount);
        Item newItem = this.getItem(pIndex).getItem();
        if (extracted.getItem() != newItem) {
            this.slotCache.replaceSlotWithItem(extracted.getItem(), newItem, pIndex);
        }
        this.updateFill();
        return extracted;
    }

    public ItemStack removeItemNoUpdate(int pIndex) {
        ItemStack extracted = super.removeItemNoUpdate(pIndex);
        Item newItem = this.getItem(pIndex).getItem();
        if (extracted.getItem() != newItem) {
            this.slotCache.replaceSlotWithItem(extracted.getItem(), newItem, pIndex);
            System.out.println("replacing slots!");
        }
        return extracted;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.ars_nouveau.repository");
    }

    protected AbstractContainerMenu createMenu(int pId, Inventory pPlayer) {
        return ChestMenu.sixRows((int)pId, (Inventory)pPlayer, (Container)this);
    }

    public int getContainerSize() {
        return 54;
    }

    public void invalidateNetwork() {
        if (this.level.isClientSide) {
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.invalidateNetwork(visited);
    }

    protected void invalidateNetwork(Set<BlockPos> visited) {
        visited.add(this.worldPosition);
        for (Direction direction : Direction.values()) {
            BlockPos pos = this.worldPosition.relative(direction);
            if (visited.contains(pos)) continue;
            visited.add(pos);
            if (!this.level.isLoaded(pos)) continue;
            BlockEntity neighbor = this.level.getBlockEntity(pos);
            if (neighbor instanceof RepositoryTile) {
                RepositoryTile repositoryTile = (RepositoryTile)neighbor;
                repositoryTile.invalidateNetwork(visited);
                continue;
            }
            if (!(neighbor instanceof RepositoryCatalogTile)) continue;
            RepositoryCatalogTile controllerTile = (RepositoryCatalogTile)neighbor;
            controllerTile.invalidateNetwork();
        }
    }

    public void initCache() {
        if (!this.level.isClientSide) {
            this.slotCache = new SlotCache(false);
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stack = this.getItem(i);
                this.slotCache.getOrCreateSlots(stack.getItem()).add(i);
            }
            this.filterableItemHandler = new FilterableItemHandler((IItemHandler)new InvWrapper((Container)this), this.filterSet).withSlotCache(this.slotCache);
        }
    }

    public void attachFilters() {
        this.filterSet = FilterSet.forPosition(this.level, this.worldPosition);
        this.filterableItemHandler = new FilterableItemHandler((IItemHandler)new InvWrapper((Container)this), this.filterSet).withSlotCache(this.slotCache);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
        pTag.putInt("fillLevel", this.fillLevel);
        pTag.putInt("configuration", this.configuration);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
        this.fillLevel = pTag.getInt("fillLevel");
        this.configuration = pTag.getInt("configuration");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.handleUpdateTag(pkt.getTag() == null ? new CompoundTag() : pkt.getTag(), lookupProvider);
    }

    public boolean updateBlock() {
        if (this.level == null) {
            return false;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.setChanged();
        return true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    public void onLoad() {
        super.onLoad();
        this.initCache();
        this.attachFilters();
        this.level.scheduleTick(this.worldPosition, (Block)BlockRegistry.REPOSITORY.get(), 1);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.hasCustomName()) {
            tooltip.add(this.getCustomName());
        }
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.filterableItemHandler == null || !this.filterableItemHandler.canInsert(stack).valid()) {
            return stack;
        }
        return this.filterableItemHandler.insertItemStacked(stack, simulate);
    }

    @Override
    public boolean hasExistingSlotsForInsertion(ItemStack stack) {
        return this.slotCache.getIfPresent(stack.getItem()) != null && !this.slotCache.getIfPresent(stack.getItem()).isEmpty();
    }

    @Override
    public ItemStack extractByItem(Item item, int count, boolean simulate, Predicate<ItemStack> filter) {
        Collection<Integer> slots = this.slotCache.getIfPresent(item);
        if (slots == null) {
            return ItemStack.EMPTY;
        }
        for (Integer slot : slots) {
            ItemStack stack = this.getItem(slot);
            if (!filter.test(stack)) continue;
            if (simulate) {
                return stack.copy();
            }
            return this.invWrapper.extractItem(slot.intValue(), count, simulate);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemScroll.SortPref getInsertionPreference(ItemStack stack) {
        ItemScroll.SortPref defaultPref = this.filterSet.getHighestPreference(stack);
        return switch (defaultPref) {
            case ItemScroll.SortPref.INVALID -> ItemScroll.SortPref.INVALID;
            case ItemScroll.SortPref.LOW -> {
                if (this.hasExistingSlotsForInsertion(stack)) {
                    yield ItemScroll.SortPref.HIGH;
                }
                yield ItemScroll.SortPref.LOW;
            }
            default -> defaultPref;
        };
    }
}

