/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.IMultiSourceTargetProvider;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RelaySplitterTile
extends RelayTile
implements IMultiSourceTargetProvider {
    ArrayList<BlockPos> toList = new ArrayList();
    ArrayList<BlockPos> fromList = new ArrayList();

    public RelaySplitterTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.RELAY_SPLITTER_TILE.get(), pos, state);
    }

    public RelaySplitterTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean setTakeFrom(BlockPos pos) {
        return this.closeEnough(pos) && this.fromList.add(pos) && this.updateBlock();
    }

    @Override
    public boolean setSendTo(BlockPos pos) {
        return this.closeEnough(pos) && this.toList.add(pos) && this.updateBlock();
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        for (BlockPos toPos : this.toList) {
            list.add(ColorPos.centered(toPos, ParticleColor.TO_HIGHLIGHT));
        }
        for (BlockPos fromPos : this.fromList) {
            list.add(ColorPos.centered(fromPos, ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    @Override
    public void clearPos() {
        this.toList.clear();
        this.fromList.clear();
        this.updateBlock();
    }

    public void processFromList() {
        if (this.fromList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        int ratePer = this.getTransferRate() / this.fromList.size();
        if (ratePer == 0) {
            return;
        }
        for (BlockPos fromPos : this.fromList) {
            int transfer;
            if (!this.level.isLoaded(fromPos)) continue;
            Object object = this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, fromPos, null);
            if (object instanceof ISourceCap) {
                ISourceCap sourceHandler = (ISourceCap)object;
                transfer = this.transferSource(sourceHandler, this.getSourceStorage(), ratePer);
            } else {
                object = this.level.getBlockEntity(fromPos);
                if (object instanceof AbstractSourceMachine) {
                    AbstractSourceMachine fromTile = (AbstractSourceMachine)object;
                    int fromRate = Math.min(ratePer, this.getTransferRate(fromTile, this));
                    transfer = this.transferSource(fromTile, this, fromRate);
                } else {
                    stale.add(fromPos);
                    continue;
                }
            }
            if (transfer <= 0) continue;
            this.createParticles(fromPos, this.worldPosition);
        }
        for (BlockPos s : stale) {
            this.fromList.remove(s);
            this.updateBlock();
        }
    }

    public void createParticles(BlockPos from, BlockPos to) {
        ParticleUtil.spawnFollowProjectile(this.level, from, to, this.getColor());
    }

    public void processToList() {
        if (this.toList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        int ratePer = this.getSource() / this.toList.size();
        if (ratePer == 0) {
            return;
        }
        for (BlockPos toPos : this.toList) {
            int transfer;
            if (!this.level.isLoaded(toPos)) continue;
            Object object = this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, toPos, null);
            if (object instanceof ISourceCap) {
                ISourceCap sourceHandler = (ISourceCap)object;
                transfer = this.transferSource(this.getSourceStorage(), sourceHandler, ratePer);
            } else {
                object = this.level.getBlockEntity(toPos);
                if (object instanceof AbstractSourceMachine) {
                    AbstractSourceMachine toTile = (AbstractSourceMachine)object;
                    transfer = this.transferSource(this, toTile, ratePer);
                } else {
                    stale.add(toPos);
                    continue;
                }
            }
            if (transfer <= 0) continue;
            this.createParticles(this.worldPosition, toPos);
        }
        for (BlockPos s : stale) {
            this.toList.remove(s);
            this.updateBlock();
        }
    }

    @Override
    public void tick() {
        if (this.level.getGameTime() % 20L != 0L || this.toList.isEmpty() || this.level.isClientSide || this.disabled) {
            return;
        }
        this.processFromList();
        this.processToList();
        this.updateBlock();
    }

    @Override
    @NotNull
    protected SourceStorage createDefaultStorage() {
        return new SourceStorage(2500, 2500);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        BlockPos pos;
        super.loadAdditional(tag, pRegistries);
        this.fromList = new ArrayList();
        this.toList = new ArrayList();
        int counter = 0;
        while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "from_" + counter);
            if (!this.fromList.contains(pos)) {
                this.fromList.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "to_" + counter);
            if (!this.toList.contains(pos)) {
                this.toList.add(NBTUtil.getBlockPos(tag, "to_" + counter));
            }
            ++counter;
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        int counter = 0;
        for (BlockPos p : this.fromList) {
            NBTUtil.storeBlockPos(tag, "from_" + counter, p);
            ++counter;
        }
        counter = 0;
        for (BlockPos p : this.toList) {
            NBTUtil.storeBlockPos(tag, "to_" + counter, p);
            ++counter;
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.toList == null || this.toList.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.one_to", (Object[])new Object[]{this.toList.size()}));
        }
        if (this.fromList == null || this.fromList.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.no_from"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.relay.one_from", (Object[])new Object[]{this.fromList.size()}));
        }
    }

    @Override
    public List<BlockPos> getFromList() {
        return this.fromList;
    }

    @Override
    public List<BlockPos> getToList() {
        return this.toList;
    }
}

