/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BasicSpellTurretTile
extends ModdedTile
implements ITooltipProvider,
GeoBlockEntity,
IAnimationListener,
ITickable,
ICapabilityProvider<BasicSpellTurretTile, Void, SpellCaster> {
    boolean playRecoil;
    protected SpellCaster spellCaster = new SpellCaster(0, null, false, null, 1);
    @Nullable
    UUID uuid = null;
    AnimationController castController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BasicSpellTurretTile(BlockEntityType<?> p_i48289_1_, BlockPos pos, BlockState state) {
        super(p_i48289_1_, pos, state);
    }

    public BasicSpellTurretTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.BASIC_SPELL_TURRET_TILE, pos, state);
    }

    public int getManaCost() {
        return this.spellCaster.getSpell().getCost();
    }

    public void setPlayer(UUID uuid) {
        this.uuid = uuid;
    }

    public void setSpell(Spell spell) {
        this.spellCaster = (SpellCaster)this.spellCaster.setSpell(spell, 0);
    }

    public void shootSpell() {
        Level level;
        BlockPos pos = this.getBlockPos();
        if (this.spellCaster.getSpell().isEmpty() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int manaCost = this.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceMultipleWithParticles(pos, (Level)level2, 10, manaCost) == null) {
            return;
        }
        Networking.sendToNearbyClient((Level)level2, pos, (CustomPacketPayload)new PacketOneShotAnimation(pos));
        Position iposition = BasicSpellTurret.getDispensePosition(pos, (Direction)level2.getBlockState(pos).getValue((Property)BasicSpellTurret.FACING));
        Direction direction = (Direction)level2.getBlockState(pos).getValue((Property)BasicSpellTurret.FACING);
        ANFakePlayer fakePlayer = this.uuid != null ? FakePlayerFactory.get((ServerLevel)level2, (GameProfile)new GameProfile(this.uuid, "")) : ANFakePlayer.getPlayer(level2);
        fakePlayer.setPos(pos.getX(), pos.getY(), pos.getZ());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext((Level)level2, this.spellCaster.getSpell(), (LivingEntity)fakePlayer, new TileCaster(this, SpellContext.CasterType.TURRET)));
        if (resolver.castType != null && BasicSpellTurret.TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            BasicSpellTurret.TURRET_BEHAVIOR_MAP.get(resolver.castType).onCast(resolver, level2, pos, (Player)fakePlayer, iposition, direction);
            this.spellCaster.playSound(pos, (Level)level2, null, this.spellCaster.getCurrentSound(), SoundSource.BLOCKS);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("spell_caster", ANCodecs.encode(SpellCaster.CODEC.codec(), this.spellCaster));
        if (this.uuid != null) {
            pTag.putUUID("uuid", this.uuid);
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.spellCaster = (SpellCaster)ANCodecs.decode(SpellCaster.CODEC.codec(), pTag.get("spell_caster"));
        if (pTag.contains("uuid")) {
            this.uuid = pTag.getUUID("uuid");
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell_turret.casting"));
        if (!this.spellCaster.getSpellName().isEmpty()) {
            tooltip.add((Component)Component.literal((String)this.spellCaster.getSpellName()));
        }
        tooltip.add((Component)Component.literal((String)this.spellCaster.getSpell().getDisplayString()));
    }

    public PlayState walkPredicate(AnimationState<?> event) {
        if (this.playRecoil) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("recoil"));
            this.playRecoil = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        this.castController = new AnimationController((GeoAnimatable)this, "castController", 0, this::walkPredicate);
        data.add(this.castController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void startAnimation(int arg) {
        this.playRecoil = true;
    }

    @Nullable
    public SpellCaster getCapability(BasicSpellTurretTile object, Void context) {
        return this.spellCaster;
    }
}

