/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.RunicChalk;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.VoxelShapeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RuneBlock
extends TickableModBlock {
    public static VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty FLOOR = BooleanProperty.create((String)"floor");
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public RuneBlock() {
        this(RuneBlock.defaultProperties().noCollission().noOcclusion().strength(0.0f, 0.0f));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FLOOR, (Comparable)Boolean.valueOf(true)));
    }

    public RuneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof RuneTile) {
            RuneTile runeTile = (RuneTile)blockEntity;
            if (!worldIn.isClientSide && stack.getItem() instanceof RunicChalk && runeTile.isTemporary) {
                runeTile.isTemporary = false;
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.rune.setperm"));
                return ItemInteractionResult.SUCCESS;
            }
            if (!(stack.getItem() instanceof SpellParchment) || worldIn.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            Spell spell = SpellCasterRegistry.from(stack).getSpell();
            if (spell.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!(spell.get(0) instanceof MethodTouch)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.rune.touch"));
                return ItemInteractionResult.SUCCESS;
            }
            runeTile.setSpell(spell);
            runeTile.setPlayer(player.getUUID());
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.spell_set"));
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.tick(state, worldIn, pos, rand);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof RuneTile) {
            RuneTile rune = (RuneTile)blockEntity;
            if (rune.touchedEntity != null) {
                rune.castSpell(rune.touchedEntity);
                rune.touchedEntity = null;
            }
        }
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Entity entityIn) {
        Object object;
        super.entityInside(state, worldIn, pos, entityIn);
        List entities = worldIn.getEntitiesOfClass(Entity.class, this.getShape(state, (BlockGetter)worldIn, pos, CollisionContext.empty()).bounds().move(pos), EntitySelector.NO_SPECTATORS.and(p_289691_ -> !p_289691_.isIgnoringBlockTriggers()));
        if (!entities.isEmpty() && (object = worldIn.getBlockEntity(pos)) instanceof RuneTile) {
            RuneTile rune = (RuneTile)object;
            if (rune.spell != null) {
                AbstractSpellPart part;
                object = rune.spell.recipe().iterator();
                while (object.hasNext() && (part = (AbstractSpellPart)object.next()) instanceof IFilter) {
                    IFilter filter = (IFilter)((Object)part);
                    if (filter.shouldResolveOnEntity(entityIn, worldIn)) continue;
                    return;
                }
            }
            rune.touchedEntity = (Entity)entities.getFirst();
            worldIn.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof RuneTile) {
            RuneTile runeTile = (RuneTile)blockEntity;
            runeTile.disabled = world.hasNeighborSignal(pos);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return switch (facing) {
            case Direction.EAST -> VoxelShapeUtils.rotate(shape, Direction.WEST);
            case Direction.NORTH -> VoxelShapeUtils.rotateX(shape, 270);
            case Direction.DOWN -> VoxelShapeUtils.rotate(shape, Direction.UP);
            case Direction.WEST -> VoxelShapeUtils.rotate(shape, Direction.EAST);
            case Direction.SOUTH -> VoxelShapeUtils.rotateX(shape, 90);
            default -> shape;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED}).add(new Property[]{FACING}).add(new Property[]{FLOOR});
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RuneTile(pos, state);
    }
}

