/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArsGeoBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.tile.RedstoneRelayTile;
import com.hollingsworth.arsnouveau.common.items.AnimBlockItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.util.Color;

public class RedstoneRelayRenderer
extends ArsGeoBlockRenderer<RedstoneRelayTile> {
    public RedstoneRelayRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, new GenericModel("redstone_relay"));
    }

    public void renderRecursively(PoseStack poseStack, RedstoneRelayTile animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        ArrayList<String> strings = new ArrayList<String>(List.of(new String[]{"framework_input", "bone", "bone2", "bone3", "bone4"}));
        if (strings.contains(bone.getName())) {
            super.renderRecursively(poseStack, (BlockEntity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, Color.WHITE.argbInt());
        } else {
            super.renderRecursively(poseStack, (BlockEntity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        }
    }

    @Override
    public void actuallyRender(PoseStack poseStack, RedstoneRelayTile animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public Color getRenderColor(RedstoneRelayTile animatable, float partialTick, int packedLight) {
        return new Color(0xFF000000 | RedStoneWireBlock.getColorForPower((int)Math.max(1, animatable.getOutputPower())));
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(new GenericModel("redstone_relay")){

            public void renderRecursively(PoseStack poseStack, AnimBlockItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
                ArrayList<String> strings = new ArrayList<String>(List.of(new String[]{"framework_input", "bone", "bone2", "bone3", "bone4"}));
                if (strings.contains(bone.getName())) {
                    super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, Color.WHITE.argbInt());
                } else {
                    super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
                }
            }

            public Color getRenderColor(AnimBlockItem animatable, float partialTick, int packedLight) {
                return Color.ofOpaque((int)RedStoneWireBlock.getColorForPower((int)1));
            }
        };
    }
}

