/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WealdWalkerModel<W extends WealdWalker>
extends GeoModel<W> {
    String type;

    public WealdWalkerModel(String type) {
        this.type = type;
    }

    public void setCustomAnimations(W entity, long uniqueID, @Nullable AnimationState<W> customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * 0.010453292f);
        head.setRotY(extraData.netHeadYaw() * 0.015453292f);
        if (((Boolean)entity.getEntityData().get(WealdWalker.CASTING)).booleanValue()) {
            GeoBone frontLeftLeg = this.getAnimationProcessor().getBone("leg_right");
            GeoBone frontRightLeg = this.getAnimationProcessor().getBone("leg_left");
            frontLeftLeg.setRotX(Mth.cos((float)(((WealdWalker)entity).walkAnimation.position() * 0.6662f)) * 1.4f * ((WealdWalker)entity).walkAnimation.speed());
            frontRightLeg.setRotX(Mth.cos((float)(((WealdWalker)entity).walkAnimation.position() * 0.6662f + (float)Math.PI)) * 1.4f * ((WealdWalker)entity).walkAnimation.speed());
        }
    }

    public ResourceLocation getModelResource(WealdWalker walker) {
        return walker.isBaby() ? ArsNouveau.prefix("geo/" + this.type + "_waddler.geo.json") : ArsNouveau.prefix("geo/" + this.type + "_walker.geo.json");
    }

    public ResourceLocation getTextureResource(WealdWalker walker) {
        return walker.isBaby() ? ArsNouveau.prefix("textures/entity/" + this.type + "_waddler.png") : ArsNouveau.prefix("textures/entity/" + this.type + "_walker.png");
    }

    public ResourceLocation getAnimationResource(WealdWalker walker) {
        return walker.isBaby() ? ArsNouveau.prefix("animations/weald_waddler_animations.json") : ArsNouveau.prefix("animations/weald_walker_animations.json");
    }
}

