/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class DummyRenderer
extends LivingEntityRenderer<EntityDummy, PlayerModel<EntityDummy>> {
    private final PlayerModel<EntityDummy> playerModel;
    private final PlayerModel<EntityDummy> playerModelSlim;

    public DummyRenderer(EntityRendererProvider.Context p_i46102_1_) {
        this(p_i46102_1_, false);
    }

    public ResourceLocation getTextureLocation(EntityDummy p_110775_1_) {
        return p_110775_1_.getSkinTextureLocation();
    }

    public DummyRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), slim), 0.5f);
        this.playerModel = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.playerModelSlim = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
    }

    public void render(EntityDummy p_225623_1_, float p_225623_2_, float p_225623_3_, PoseStack p_225623_4_, MultiBufferSource p_225623_5_, int p_225623_6_) {
        this.setModelProperties(p_225623_1_);
        super.render((LivingEntity)p_225623_1_, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    public Vec3 getRenderOffset(EntityDummy p_225627_1_, float p_225627_2_) {
        return p_225627_1_.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : super.getRenderOffset((Entity)p_225627_1_, p_225627_2_);
    }

    private void setModelProperties(EntityDummy pEntityDummy) {
        this.model = pEntityDummy.isSlim() ? this.playerModelSlim : this.playerModel;
        PlayerModel playermodel = (PlayerModel)this.getModel();
        if (pEntityDummy.isSpectator()) {
            playermodel.setAllVisible(false);
            playermodel.head.visible = true;
            playermodel.hat.visible = true;
        } else {
            playermodel.setAllVisible(true);
            playermodel.crouching = pEntityDummy.isCrouching();
            HumanoidModel.ArmPose bipedmodel$armpose = DummyRenderer.getArmPose(pEntityDummy, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose bipedmodel$armpose1 = DummyRenderer.getArmPose(pEntityDummy, InteractionHand.OFF_HAND);
            if (bipedmodel$armpose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = pEntityDummy.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (pEntityDummy.getMainArm() == HumanoidArm.RIGHT) {
                playermodel.rightArmPose = bipedmodel$armpose;
                playermodel.leftArmPose = bipedmodel$armpose1;
            } else {
                playermodel.rightArmPose = bipedmodel$armpose1;
                playermodel.leftArmPose = bipedmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(EntityDummy pEntityDummy, InteractionHand p_241741_1_) {
        ItemStack itemstack = pEntityDummy.getItemInHand(p_241741_1_);
        if (itemstack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (pEntityDummy.getUsedItemHand() == p_241741_1_ && pEntityDummy.getUseItemRemainingTicks() > 0) {
            UseAnim useaction = itemstack.getUseAnimation();
            if (useaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAnim.CROSSBOW && p_241741_1_ == pEntityDummy.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!pEntityDummy.swinging && itemstack.getItem() == Items.CROSSBOW && CrossbowItem.isCharged((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void scale(EntityDummy p_225620_1_, PoseStack p_225620_2_, float p_225620_3_) {
        p_225620_2_.scale(0.9375f, 0.9375f, 0.9375f);
    }

    public void renderRightHand(PoseStack p_229144_1_, MultiBufferSource p_229144_2_, int p_229144_3_, EntityDummy p_229144_4_) {
        this.renderHand(p_229144_1_, p_229144_2_, p_229144_3_, p_229144_4_, ((PlayerModel)this.model).rightArm, ((PlayerModel)this.model).rightSleeve);
    }

    public void renderLeftHand(PoseStack p_229146_1_, MultiBufferSource p_229146_2_, int p_229146_3_, EntityDummy p_229146_4_) {
        this.renderHand(p_229146_1_, p_229146_2_, p_229146_3_, p_229146_4_, ((PlayerModel)this.model).leftArm, ((PlayerModel)this.model).leftSleeve);
    }

    protected void renderNameTag(EntityDummy pEntity, Component pDisplayName, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, float pPartialTick) {
        if (!pEntity.shouldShowName()) {
            return;
        }
        super.renderNameTag((Entity)pEntity, pDisplayName, pPoseStack, pBuffer, pPackedLight, pPartialTick);
    }

    private void renderHand(PoseStack p_229145_1_, MultiBufferSource p_229145_2_, int p_229145_3_, EntityDummy p_229145_4_, ModelPart p_229145_5_, ModelPart p_229145_6_) {
        PlayerModel playermodel = (PlayerModel)this.getModel();
        this.setModelProperties(p_229145_4_);
        playermodel.attackTime = 0.0f;
        playermodel.crouching = false;
        playermodel.swimAmount = 0.0f;
        playermodel.setupAnim((LivingEntity)p_229145_4_, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        p_229145_5_.xRot = 0.0f;
        p_229145_5_.render(p_229145_1_, p_229145_2_.getBuffer(RenderType.entitySolid((ResourceLocation)p_229145_4_.getSkinTextureLocation())), p_229145_3_, OverlayTexture.NO_OVERLAY);
        p_229145_6_.xRot = 0.0f;
        p_229145_6_.render(p_229145_1_, p_229145_2_.getBuffer(RenderType.entityTranslucent((ResourceLocation)p_229145_4_.getSkinTextureLocation())), p_229145_3_, OverlayTexture.NO_OVERLAY);
    }

    protected void setupRotations(EntityDummy p_225621_1_, PoseStack p_225621_2_, float p_225621_3_, float p_225621_4_, float p_225621_5_, float pScale) {
        float f = p_225621_1_.getSwimAmount(p_225621_5_);
        if (p_225621_1_.isFallFlying()) {
            super.setupRotations((LivingEntity)p_225621_1_, p_225621_2_, p_225621_3_, p_225621_4_, p_225621_5_, pScale);
            float f1 = (float)p_225621_1_.getFallFlyingTicks() + p_225621_5_;
            float f2 = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_225621_1_.isAutoSpinAttack()) {
                p_225621_2_.mulPose(Axis.XP.rotationDegrees(f2 * (-90.0f - p_225621_1_.getXRot())));
            }
            Vec3 vector3d = p_225621_1_.getViewVector(p_225621_5_);
            Vec3 vector3d1 = p_225621_1_.getDeltaMovement();
            double d0 = vector3d1.horizontalDistanceSqr();
            double d1 = vector3d.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.x * vector3d.x + vector3d1.z * vector3d.z) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.x * vector3d.z - vector3d1.z * vector3d.x;
                p_225621_2_.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.setupRotations((LivingEntity)p_225621_1_, p_225621_2_, p_225621_3_, p_225621_4_, p_225621_5_, pScale);
            float f3 = p_225621_1_.isInWater() ? -90.0f - p_225621_1_.getXRot() : -90.0f;
            float f4 = Mth.lerp((float)f, (float)0.0f, (float)f3);
            p_225621_2_.mulPose(Axis.XP.rotationDegrees(f4));
            if (p_225621_1_.isVisuallySwimming()) {
                p_225621_2_.translate(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.setupRotations((LivingEntity)p_225621_1_, p_225621_2_, p_225621_3_, p_225621_4_, p_225621_5_, pScale);
        }
    }
}

