/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ParticleRenderTypes;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class ParticleSparkle
extends TextureSheetParticle {
    public float colorR;
    public float colorG;
    public float colorB;
    public float initScale;
    public float initAlpha = 0.0f;

    protected ParticleSparkle(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float scale, int lifetime, SpriteSet sprite) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        if ((double)this.colorR > 1.0) {
            this.colorR /= 255.0f;
        }
        if ((double)this.colorG > 1.0) {
            this.colorG /= 255.0f;
        }
        if ((double)this.colorB > 1.0) {
            this.colorB /= 255.0f;
        }
        this.setColor(this.colorR, this.colorG, this.colorB);
        this.lifetime = lifetime;
        this.quadSize = scale;
        this.hasPhysics = false;
        this.initScale = scale;
        this.xd = ParticleUtil.inRange(-0.01, 0.01);
        this.yd = -0.02;
        this.zd = ParticleUtil.inRange(-0.01, 0.01);
        this.pickSprite(sprite);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.EMBER_RENDER;
    }

    public int getLightColor(float pTicks) {
        return 255;
    }

    public void tick() {
        super.tick();
        float lifeCoeff = (float)this.age / (float)this.lifetime;
        this.alpha = 1.0f - lifeCoeff;
    }

    public boolean isAlive() {
        return this.age < this.lifetime;
    }
}

