/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ColoredDynamicTypeData
implements ParticleOptions {
    private ParticleType<ColoredDynamicTypeData> type;
    public ParticleColor color;
    float scale;
    int age;
    public static final MapCodec<ColoredDynamicTypeData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.FLOAT.fieldOf("scale").forGetter(d -> Float.valueOf(d.scale)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age)).apply((Applicative)instance, ColoredDynamicTypeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ColoredDynamicTypeData> STREAM_CODEC = StreamCodec.of(ColoredDynamicTypeData::toNetwork, ColoredDynamicTypeData::fromNetwork);

    public static void toNetwork(RegistryFriendlyByteBuf buf, ColoredDynamicTypeData data) {
        buf.writeFloat(data.color.getRed());
        buf.writeFloat(data.color.getGreen());
        buf.writeFloat(data.color.getBlue());
        buf.writeFloat(data.scale);
        buf.writeInt(data.age);
    }

    public static ColoredDynamicTypeData fromNetwork(RegistryFriendlyByteBuf buffer) {
        float r = buffer.readFloat();
        float g = buffer.readFloat();
        float b = buffer.readFloat();
        float scale = buffer.readFloat();
        int age = buffer.readInt();
        return new ColoredDynamicTypeData(r, g, b, scale, age);
    }

    public ParticleType<?> getType() {
        return this.type;
    }

    public ColoredDynamicTypeData(float r, float g, float b, float scale, int age) {
        this.type = (ParticleType)ModParticles.LINE_TYPE.get();
        this.color = new ParticleColor(r, g, b);
        this.scale = scale;
        this.age = age;
    }

    public ColoredDynamicTypeData(ParticleType<ColoredDynamicTypeData> particleTypeData, ParticleColor color, float scale, int age) {
        this.type = particleTypeData;
        this.color = color;
        this.scale = scale;
        this.age = age;
    }
}

