/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.search.Search;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class SearchScreen
extends BaseDocScreen {
    List<DocEntryButton> searchResults = new ArrayList<DocEntryButton>();
    List<Search.Result> resultDocs = new ArrayList<Search.Result>();

    public SearchScreen(String searchString) {
        this.previousString = searchString;
    }

    @Override
    public void init() {
        super.init();
        this.onSearchChanged(this.previousString);
        this.searchBar.setValue(this.previousString);
        this.searchBar.mouseClicked(0.0, 0.0, 1);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        DocClientUtils.drawHeader((Component)Component.translatable((String)"ars_nouveau.doc.search_results"), graphics, this.screenLeft + 19, this.screenTop + 17, 118, mouseX, mouseY, partialTicks);
        DocClientUtils.blit(graphics, DocAssets.SEARCH_SPLASH, this.screenLeft + 19 + DocAssets.SEARCH_SPLASH.width() / 2 - 10, this.screenBottom - DocAssets.SEARCH_SPLASH.height() - 30);
        DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.search_desc"), graphics, this.screenLeft + 19, this.screenTop + 17 + 20, 118, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onArrowIndexChange() {
        this.maxArrowIndex = (this.resultDocs.size() - 1) / 9;
        super.onArrowIndexChange();
        for (DocEntryButton button : this.searchResults) {
            this.removeWidget((GuiEventListener)button);
        }
        this.searchResults.clear();
        this.getRightPageButtons(this.resultDocs, this.arrowIndex * 9, (this.arrowIndex + 1) * 9);
    }

    public void getRightPageButtons(List<Search.Result> docs, int from, int to) {
        if (from > docs.size()) {
            return;
        }
        List<Search.Result> slicedDocs = docs.subList(from, Math.min(to, docs.size()));
        for (int i = 0; i < Math.min(slicedDocs.size(), to); ++i) {
            Search.Result entry = slicedDocs.get(i);
            DocEntryButton button = new DocEntryButton(this.screenLeft + 153, this.screenTop + 17 + 16 * i, entry.entry(), entry.icon(), entry.displayTitle(), b -> this.previousScreen.transition(new PageHolderScreen(entry.entry())));
            this.addRenderableWidget((GuiEventListener)button);
            this.searchResults.add(button);
        }
    }

    @Override
    public void onSearchChanged(String str) {
        if (this.previousString != null && str.equals(this.previousString)) {
            return;
        }
        this.previousString = str;
        if (str.isEmpty()) {
            this.previousScreen.previousString = "";
            this.goBack();
        } else {
            this.resultDocs = Search.search(this.previousString);
            this.onArrowIndexChange();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.searchBar.setFocused(true);
        this.searchBar.keyPressed(keyCode, scanCode, modifiers);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

