/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.client.emi.EmiArsNouveauPlugin;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BuddingConversionRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EmiBuddingConversionRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final BuddingConversionRecipe recipe;

    public EmiBuddingConversionRecipe(ResourceLocation id, BuddingConversionRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiArsNouveauPlugin.BUDDING_CONVERSION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{this.recipe.input()})));
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemLike)this.recipe.result()));
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 24;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)this.recipe.input()), 6, 4);
        widgets.addFillingArrow(48, 5, 2000);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)this.recipe.result()), 98, 4).recipeContext((EmiRecipe)this);
    }
}

