/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LevelPosMap {
    public Map<String, Set<BlockPos>> posMap = new ConcurrentHashMap<String, Set<BlockPos>>();
    public BiFunction<Level, BlockPos, Boolean> removeFunction;

    public LevelPosMap(BiFunction<Level, BlockPos, Boolean> removeFunction) {
        this.removeFunction = removeFunction;
    }

    public void addPosition(Level world, BlockPos pos) {
        String key = world.dimension().location().toString();
        if (!this.posMap.containsKey(key)) {
            this.posMap.put(key, new HashSet());
        }
        this.posMap.get(key).add(pos);
    }

    public void applyForRange(Level level, BlockPos atPos, double distanceFrom, Function<BlockPos, Boolean> breakEarlyFunction) {
        this.applyForRange(level, new Vec3((double)atPos.getX(), (double)atPos.getY(), (double)atPos.getZ()), distanceFrom, breakEarlyFunction);
    }

    public void applyForRange(Level level, Vec3 atPos, double distanceFrom, Function<BlockPos, Boolean> breakEarlyFunction) {
        String key = level.dimension().location().toString();
        if (!this.posMap.containsKey(key)) {
            return;
        }
        Set worldList = this.posMap.getOrDefault(key, new HashSet());
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        for (BlockPos p : worldList) {
            if (!level.isLoaded(p)) continue;
            Vec3 vec3 = new Vec3((double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5);
            if (!(BlockUtil.distanceFrom(atPos, vec3) <= distanceFrom)) continue;
            if (this.removeFunction.apply(level, p).booleanValue()) {
                stale.add(p);
                continue;
            }
            if (!breakEarlyFunction.apply(p).booleanValue()) continue;
            break;
        }
        for (BlockPos pos : stale) {
            this.posMap.get(key).remove(pos);
        }
    }
}

