/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record SpellSlotMap(Map<Integer, Spell> slots) {
    public static final Codec<SpellSlotMap> CODEC = ANCodecs.intMap(Spell.CODEC.codec(), SpellSlotMap::new, SpellSlotMap::slots);
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellSlotMap> STREAM = StreamCodec.ofMember((val, buf) -> {
        Set<Map.Entry<Integer, Spell>> entries = val.slots.entrySet();
        buf.writeInt(entries.size());
        for (Map.Entry<Integer, Spell> entry : entries) {
            buf.writeInt(entry.getKey().intValue());
            Spell.STREAM.encode(buf, (Object)entry.getValue());
        }
    }, buf -> {
        int size = buf.readInt();
        ImmutableMap.Builder immutableMap = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            int key = buf.readInt();
            Spell value = (Spell)Spell.STREAM.decode(buf);
            immutableMap.put((Object)key, (Object)value);
        }
        return new SpellSlotMap((Map<Integer, Spell>)immutableMap.build());
    });

    public Spell getOrDefault(int slot, Spell spell) {
        return this.slots.getOrDefault(slot, spell);
    }

    public Spell get(int slot) {
        return this.slots.get(slot);
    }

    public SpellSlotMap put(int slot, Spell spell) {
        return new SpellSlotMap(Util.copyAndPut(this.slots, (Object)slot, (Object)spell));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellSlotMap that = (SpellSlotMap)o;
        return Objects.equals(this.slots, that.slots);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.slots);
    }
}

