/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class Spell {
    public static final MapCodec<Spell> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(s -> s.name), (App)ParticleColor.CODEC.fieldOf("color").forGetter(s -> s.color), (App)ConfiguredSpellSound.CODEC.fieldOf("sound").forGetter(s -> s.sound), (App)Codec.list(AbstractSpellPart.CODEC).fieldOf("recipe").forGetter(s -> s.recipe)).apply((Applicative)instance, Spell::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Spell> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeUtf(val.name);
        ParticleColor.STREAM.encode(buf, (Object)val.color);
        ConfiguredSpellSound.STREAM.encode(buf, (Object)val.sound);
        AbstractSpellPart.STREAM_LIST.encode(buf, val.recipe);
    }, buf -> {
        String name = buf.readUtf();
        ParticleColor color = (ParticleColor)ParticleColor.STREAM.decode(buf);
        ConfiguredSpellSound sound = (ConfiguredSpellSound)ConfiguredSpellSound.STREAM.decode(buf);
        List recipe = (List)AbstractSpellPart.STREAM_LIST.decode(buf);
        return new Spell(name, color, sound, recipe);
    });
    private final List<AbstractSpellPart> recipe;
    private final String name;
    private final ParticleColor color;
    private final ConfiguredSpellSound sound;

    public Spell() {
        this("", ParticleColor.defaultParticleColor(), ConfiguredSpellSound.DEFAULT, (List<AbstractSpellPart>)ImmutableList.of());
    }

    public Spell(AbstractSpellPart ... spellParts) {
        this(Arrays.asList(spellParts));
    }

    public Spell(List<AbstractSpellPart> recipe) {
        this("", ParticleColor.defaultParticleColor(), ConfiguredSpellSound.DEFAULT, recipe);
    }

    public Spell(String name, ParticleColor color, ConfiguredSpellSound configuredSpellSound, List<AbstractSpellPart> abstractSpellParts) {
        this.name = name;
        this.color = color;
        this.sound = configuredSpellSound;
        this.recipe = ImmutableList.copyOf(abstractSpellParts);
    }

    public ConfiguredSpellSound sound() {
        return this.sound;
    }

    public Iterable<AbstractSpellPart> recipe() {
        return this.recipe;
    }

    public List<AbstractSpellPart> unsafeList() {
        return this.recipe;
    }

    public AbstractSpellPart get(int index) {
        return this.recipe.get(index);
    }

    public int size() {
        return this.recipe.size();
    }

    public int indexOf(AbstractSpellPart part) {
        return this.recipe.indexOf(part);
    }

    public Spell add(AbstractSpellPart spellPart) {
        return new Spell(this.name, this.color, this.sound, Util.copyAndAdd(this.recipe, (Object)spellPart));
    }

    public Spell add(AbstractSpellPart ... spellParts) {
        Spell spell = this;
        for (AbstractSpellPart part : spellParts) {
            spell = spell.add(part);
        }
        return spell;
    }

    public Spell add(AbstractSpellPart spellPart, int count) {
        Spell spell = this;
        for (int i = 0; i < count; ++i) {
            spell = spell.add(spellPart);
        }
        return spell;
    }

    public Spell setRecipe(@NotNull List<AbstractSpellPart> recipe) {
        return new Spell(this.name, this.color, this.sound, (List<AbstractSpellPart>)ImmutableList.copyOf(recipe));
    }

    public Spell withColor(@NotNull ParticleColor color) {
        return new Spell(this.name, color, this.sound, this.recipe);
    }

    public Spell withSound(@NotNull ConfiguredSpellSound sound) {
        return new Spell(this.name, this.color, sound, this.recipe);
    }

    public ParticleColor color() {
        return this.color;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public AbstractCastMethod getCastMethod() {
        if (this.recipe == null || this.recipe.isEmpty()) {
            return null;
        }
        return this.recipe.get(0) instanceof AbstractCastMethod ? (AbstractCastMethod)this.recipe.get(0) : null;
    }

    public List<AbstractAugment> getAugments(int startPosition, @Nullable LivingEntity caster) {
        AbstractSpellPart nextGlyph;
        ArrayList<AbstractAugment> augments = new ArrayList<AbstractAugment>();
        if (this.recipe == null || this.recipe.isEmpty()) {
            return augments;
        }
        for (int j = startPosition + 1; j < this.recipe.size() && (nextGlyph = this.recipe.get(j)) instanceof AbstractAugment; ++j) {
            AbstractAugment augment = (AbstractAugment)nextGlyph;
            augments.add(augment);
        }
        return augments;
    }

    public int getInstanceCount(AbstractSpellPart spellPart) {
        int count = 0;
        for (AbstractSpellPart abstractSpellPart : this.recipe) {
            if (!abstractSpellPart.equals(spellPart)) continue;
            ++count;
        }
        return count;
    }

    public int getBuffsAtIndex(int startPosition, @Nullable LivingEntity caster, AbstractAugment augment) {
        return (int)this.getAugments(startPosition, caster).stream().filter(a -> a.equals(augment)).count();
    }

    public int getCost() {
        int cost = 0;
        AbstractSpellPart augmentedPart = null;
        for (AbstractSpellPart part : this.recipe) {
            if (part == null) continue;
            if (!(part instanceof AbstractAugment)) {
                augmentedPart = part;
            }
            if (augmentedPart != null && part instanceof AbstractAugment) {
                AbstractAugment augment = (AbstractAugment)part;
                cost += augment.getCostForPart(augmentedPart);
                continue;
            }
            cost += part.getCastingCost();
        }
        return cost;
    }

    public boolean isEmpty() {
        return this.recipe == null || this.recipe.isEmpty();
    }

    public String getDisplayString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.recipe.size(); ++i) {
            AbstractSpellPart spellPart = this.recipe.get(i);
            int num = 1;
            for (int j = i + 1; j < this.recipe.size() && spellPart.name.equals(this.recipe.get((int)j).name); ++j) {
                ++num;
            }
            if (num > 1) {
                str.append(spellPart.getLocaleName()).append(" x").append(num);
                i += num - 1;
            } else {
                str.append(spellPart.getLocaleName());
            }
            if (i >= this.recipe.size() - 1) continue;
            str.append(" -> ");
        }
        return str.toString();
    }

    public boolean isValid() {
        return !this.isEmpty();
    }

    public Spell add(AbstractSpellPart spellPart, int count, int index) {
        for (int i = 0; i < count; ++i) {
            this.recipe.add(index, spellPart);
        }
        return this;
    }

    public List<ResourceLocation> serializeRecipe() {
        return this.recipe.stream().map(AbstractSpellPart::getRegistryName).toList();
    }

    public Mutable mutable() {
        return new Mutable(new ArrayList<AbstractSpellPart>(this.recipe), this.name, this.color, this.sound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spell spell = (Spell)o;
        return Objects.equals(this.recipe, spell.recipe) && Objects.equals(this.name, spell.name) && Objects.equals(this.color, spell.color) && Objects.equals(this.sound, spell.sound);
    }

    public int hashCode() {
        return Objects.hash(this.recipe, this.name, this.color, this.sound);
    }

    public static class Mutable {
        public List<AbstractSpellPart> recipe;
        public String name;
        public ParticleColor color;
        public ConfiguredSpellSound sound;

        public Mutable(List<AbstractSpellPart> recipe, String name, ParticleColor color, ConfiguredSpellSound spellSound) {
            this.recipe = recipe;
            this.name = name;
            this.color = color;
            this.sound = spellSound;
        }

        public Mutable add(AbstractSpellPart spellPart) {
            this.recipe.add(spellPart);
            return this;
        }

        public Mutable add(AbstractSpellPart ... spellParts) {
            this.recipe.addAll(Arrays.asList(spellParts));
            return this;
        }

        public Mutable add(int index, AbstractSpellPart spellPart) {
            this.recipe.add(index, spellPart);
            return this;
        }

        public Mutable setRecipe(@NotNull List<AbstractSpellPart> recipe) {
            this.recipe = recipe;
            return this;
        }

        public Spell immutable() {
            return new Spell(this.name, this.color, this.sound, this.recipe);
        }
    }
}

