/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.ManhattenTracker;
import com.hollingsworth.arsnouveau.api.ritual.RitualUtil;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ConjureBiomeRitual
extends AbstractRitual {
    public int radius = 7;
    public int blocksPlaced;
    public int blocksBeforeSourceNeeded = 5;
    public ResourceKey<Biome> biome;
    public ManhattenTracker tracker;

    public ConjureBiomeRitual(ResourceKey<Biome> biome) {
        this.biome = biome;
    }

    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        if (this.getWorld().isClientSide) {
            return;
        }
        for (ItemStack i : this.getConsumedItems()) {
            if (!i.is(ItemTagProvider.SOURCE_GEM_TAG)) continue;
            this.radius += i.getCount();
        }
        this.tracker = new ManhattenTracker(this.getPos().below(3), this.radius, 2, this.radius);
    }

    @Override
    protected void tick() {
        if (this.getWorld().isClientSide) {
            return;
        }
        for (int i = 0; i < this.radius; ++i) {
            double z;
            double y;
            BlockPos pos = this.getPos();
            BlockPos nextPos = this.tracker.computeNext();
            if (nextPos == null) {
                this.setFinished();
                return;
            }
            double x = (double)nextPos.getX() + 0.5;
            double dist = BlockUtil.distanceFrom(new Vec3(x, y = (double)nextPos.getY() + 0.5, z = (double)nextPos.getZ() + 0.5), new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
            if (!(dist <= (double)this.radius) || !this.getWorld().getBlockState(nextPos).canBeReplaced()) continue;
            BlockState state = this.stateForPos(nextPos);
            this.setState(nextPos, state);
            RitualUtil.changeBiome(this.getWorld(), nextPos, this.biome);
            this.getWorld().playSound(null, nextPos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            ++this.blocksPlaced;
            if (this.blocksPlaced >= this.blocksBeforeSourceNeeded) {
                this.blocksPlaced = 0;
                this.setNeedsSource(true);
            }
            return;
        }
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return stack.is(ItemTagProvider.SOURCE_GEM_TAG);
    }

    @Override
    public int getSourceCost() {
        return 50;
    }

    public abstract BlockState stateForPos(BlockPos var1);

    public void setState(BlockPos pos, BlockState state) {
        this.getWorld().setBlock(pos, state, 2);
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        if (tag.contains("tracker")) {
            this.tracker = new ManhattenTracker(tag.getCompound("tracker"));
        }
        this.radius = tag.getInt("radius");
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        if (this.tracker != null) {
            tag.put("tracker", (Tag)this.tracker.serialize(new CompoundTag()));
        }
        tag.putInt("radius", this.radius);
    }
}

