/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.ServerTickRateManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ars_nouveau")
public class EventQueue {
    @NotNull
    List<ITimedEvent> events = new ObjectArrayList();
    private static EventQueue serverQueue;
    private static EventQueue clientQueue;
    private static boolean tickStepping;

    public void tick(@Nullable ServerTickEvent.Post e) {
        if (this.events.isEmpty()) {
            return;
        }
        ObjectArrayList stale = new ObjectArrayList();
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            ITimedEvent event = this.events.get(i);
            if (event.isExpired()) {
                stale.add(event);
                continue;
            }
            if (e == null) {
                event.tick(false);
                continue;
            }
            event.tick((ServerTickEvent)e);
        }
        this.events.removeAll((Collection<?>)stale);
    }

    public void addEvent(ITimedEvent event) {
        this.events.add(event);
    }

    public static EventQueue getServerInstance() {
        if (serverQueue == null) {
            serverQueue = new EventQueue();
        }
        return serverQueue;
    }

    public static EventQueue getClientQueue() {
        if (clientQueue == null) {
            clientQueue = new EventQueue();
        }
        return clientQueue;
    }

    public void clear() {
        for (ITimedEvent event : this.events) {
            event.onServerStopping();
        }
        this.events = new ObjectArrayList();
    }

    private EventQueue() {
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post e) {
        ServerTickRateManager trm = e.getServer().tickRateManager();
        if (trm.isFrozen() && !tickStepping) {
            return;
        }
        EventQueue.getServerInstance().tick(e);
    }

    @SubscribeEvent
    public static void serverTickPre(ServerTickEvent.Pre e) {
        tickStepping = e.getServer().tickRateManager().isSteppingForward();
    }

    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Post e) {
        if (!Minecraft.getInstance().isPaused()) {
            EventQueue.getClientQueue().tick(null);
        }
    }

    static {
        tickStepping = false;
    }
}

