/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PedestalRecipeEntry
extends SinglePageWidget {
    public List<Ingredient> ingredients;
    public ItemStack outputStack;
    public Ingredient reagentStack = Ingredient.EMPTY;
    public Component title;
    public DocAssets.BlitInfo image;
    public boolean spinning = false;
    public boolean drawPedestals = true;

    public PedestalRecipeEntry(BaseDocScreen parent, int x, int y, int width, int height, List<Ingredient> ingredients, ItemStack outputStack, Component title, DocAssets.BlitInfo image) {
        super(parent, x, y, width, height);
        this.ingredients = ingredients;
        this.outputStack = outputStack;
        this.title = title;
        this.image = image;
    }

    public PedestalRecipeEntry(BaseDocScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.ingredients = new ArrayList<Ingredient>();
        this.outputStack = ItemStack.EMPTY;
        this.title = Component.empty();
        this.image = DocAssets.APPARATUS_RECIPE;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        DocClientUtils.drawHeader(this.title, guiGraphics, this.x, this.y, this.width, mouseX, mouseY, partialTick);
        int yOffset = 24;
        DocClientUtils.blit(guiGraphics, this.image, this.x + 13, this.y + yOffset);
        int degreePerInput = (int)(360.0f / (float)this.ingredients.size());
        float currentDegree = this.spinning ? (float)ClientInfo.ticksInGame + partialTick : 0.0f;
        for (Ingredient input : this.ingredients) {
            int renderX = this.x + 19;
            int renderY = this.y + yOffset + 2;
            this.setTooltipIfHovered(DocClientUtils.renderIngredientAtAngle(guiGraphics, renderX, renderY, mouseX, mouseY, currentDegree, input));
            double itemX = (double)renderX + DocClientUtils.nextXAngle(currentDegree - 90.0f, 41);
            double itemY = (double)renderY + DocClientUtils.nextYAngle(currentDegree - 90.0f, 41);
            if (this.drawPedestals) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate(itemX - 3.0, itemY - 3.0, 0.0);
                DocClientUtils.blit(guiGraphics, DocAssets.PEDESTAL_FRAME, 0, 0);
                poseStack.popPose();
            }
            currentDegree += (float)degreePerInput;
        }
        if (!this.reagentStack.isEmpty()) {
            int itemX = this.x + this.width / 2 + 7;
            int itemY = this.y + yOffset + 33;
            this.setTooltipIfHovered(DocClientUtils.renderIngredient(guiGraphics, itemX, itemY, mouseX, mouseY, this.reagentStack));
        }
        int itemX = this.x + this.width / 2 - 8;
        int itemY = this.y + yOffset + 108;
        this.setTooltipIfHovered(DocClientUtils.renderItemStack(guiGraphics, itemX, itemY, mouseX, mouseY, this.outputStack));
    }
}

