/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.api.documentation.entry.RelationEntry;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.api.documentation.export.IJsonExportable;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.common.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record DocEntry(ResourceLocation id, CopyOnWriteArrayList<SinglePageCtor> pages, ItemStack renderStack, Component entryTitle, int order, Set<DocCategory> categories, List<Component> searchTags) implements Comparable<DocEntry>,
IJsonExportable
{
    public DocEntry(ResourceLocation id, ItemStack renderStack, Component component) {
        this(id, new CopyOnWriteArrayList<SinglePageCtor>(), renderStack, component, 100, ConcurrentHashMap.newKeySet(), new CopyOnWriteArrayList<Component>());
    }

    public DocEntry(ResourceLocation id, ItemStack renderStack, Component component, int order) {
        this(id, new CopyOnWriteArrayList<SinglePageCtor>(), renderStack, component, order, ConcurrentHashMap.newKeySet(), new CopyOnWriteArrayList<Component>());
    }

    public DocEntry addPage(SinglePageCtor page) {
        this.pages.add(page);
        return this;
    }

    public DocEntry addPages(List<SinglePageCtor> pages) {
        this.pages.addAll(pages);
        return this;
    }

    public DocEntry withEntryRelations(List<DocEntry> entries) {
        return this.withRelations(entries.stream().map(DocEntry::id).toList());
    }

    public DocEntry withRelations(DocEntry ... entries) {
        return this.withRelations(Arrays.stream(entries).map(DocEntry::id).toList());
    }

    public DocEntry withRelations(List<ResourceLocation> ids) {
        if (this.pages.isEmpty()) {
            return this;
        }
        SinglePageCtor singlePageCtor = this.pages.getLast();
        if (singlePageCtor instanceof RelationEntry.RelationBuilder) {
            RelationEntry.RelationBuilder relationBuilder = (RelationEntry.RelationBuilder)singlePageCtor;
            relationBuilder.entries.addAll(ids);
        } else {
            RelationEntry.RelationBuilder builder = new RelationEntry.RelationBuilder();
            builder.entries.addAll(ids);
            this.pages.add(builder);
        }
        return this;
    }

    public DocEntry withRelation(DocEntry entry) {
        return this.withRelation(entry.id);
    }

    public DocEntry withRelation(ResourceLocation id) {
        if (this.pages.isEmpty()) {
            return this;
        }
        SinglePageCtor singlePageCtor = this.pages.getLast();
        if (singlePageCtor instanceof RelationEntry.RelationBuilder) {
            RelationEntry.RelationBuilder relationBuilder = (RelationEntry.RelationBuilder)singlePageCtor;
            relationBuilder.entries.add(id);
        } else {
            RelationEntry.RelationBuilder builder = new RelationEntry.RelationBuilder();
            builder.entries.add(id);
            this.pages.add(builder);
        }
        return this;
    }

    public DocEntry withSearchTag(Component component) {
        this.searchTags.add(component);
        return this;
    }

    @Override
    public int compareTo(@NotNull DocEntry o) {
        return Integer.compare(this.order, o.order);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocEntry docEntry = (DocEntry)o;
        return Objects.equals(this.id, docEntry.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty(DocExporter.ID_PROPERTY, this.id.toString());
        object.addProperty(DocExporter.ORDER_PROPERTY, (Number)this.order);
        object.addProperty(DocExporter.ICON_PROPERTY, BuiltInRegistries.ITEM.getKey((Object)this.renderStack.getItem()).toString());
        object.addProperty(DocExporter.TITLE_PROPERTY, this.entryTitle.getString());
        object.addProperty(DocExporter.CATEGORY_PROPERY, DocumentationRegistry.getCategoryForEntry(this).id().toString());
        if (!ArsNouveau.proxy.isClientSide()) {
            return object;
        }
        JsonArray pageJsons = new JsonArray();
        for (SinglePageCtor pageCtor : this.pages) {
            BaseDocScreen screen = new BaseDocScreen();
            screen.setMinecraft(ArsNouveau.proxy.getMinecraft());
            SinglePageWidget widget = pageCtor.create(screen, 0, 0, 0, 0);
            JsonObject pageObject = widget.toJson();
            if (pageObject.isEmpty()) {
                Log.getLogger().error("Page " + String.valueOf(this.id) + " " + String.valueOf(pageCtor) + " is empty!");
                continue;
            }
            pageJsons.add((JsonElement)pageObject);
        }
        object.add("pages", (JsonElement)pageJsons);
        return object;
    }
}

