/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.api.item.ISchoolBangle;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import alexthw.ars_elemental.common.entity.mages.WaterMage;
import alexthw.ars_elemental.common.glyphs.EffectBubbleShield;
import alexthw.ars_elemental.common.mob_effects.EnthrallEffect;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.recipe.HeadCutRecipe;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="ars_elemental")
public class DamageEvents {
    @SubscribeEvent
    public static void betterFilters(SpellDamageEvent.Pre event) {
        IFilter filter;
        Object e;
        if (event.context != null && event.context.getCurrentIndex() > 1 && (e = event.context.getSpell().unsafeList().get(event.context.getCurrentIndex() - 2)) instanceof IFilter && !(filter = (IFilter)e).shouldResolveOnEntity(event.target, event.target.level())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void changeDamageType(SpellDamageEvent.Pre preSpellDamageEvent) {
        LivingEntity living;
        Entity entity;
        if (preSpellDamageEvent.damageSource.is(DamageTypeTags.IS_FIRE) && (entity = preSpellDamageEvent.target) instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE) && living.hasEffect(ModPotions.MAGIC_FIRE)) {
            DamageUtil.SpellDamageSource newSource = (DamageUtil.SpellDamageSource)DamageUtil.source((LevelAccessor)living.level(), ModRegistry.MAGIC_FIRE, (Entity)preSpellDamageEvent.damageSource.getEntity());
            DamageSource damageSource = preSpellDamageEvent.damageSource;
            if (damageSource instanceof DamageUtil.SpellDamageSource) {
                DamageUtil.SpellDamageSource oldspellDamageSource = (DamageUtil.SpellDamageSource)damageSource;
                newSource.setLuckLevel(oldspellDamageSource.getLuckLevel());
            }
            preSpellDamageEvent.damageSource = newSource;
        }
    }

    @SubscribeEvent
    public static void bypassDmgInv(EntityInvulnerabilityCheckEvent event) {
        Entity living = event.getEntity();
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getOriginalInvulnerability()) {
                DamageSource source = event.getSource();
                Set<SpellSchool> focus = ISchoolFocus.getFociSchools((LivingEntity)player);
                if (!focus.isEmpty()) {
                    boolean flag = true;
                    for (SpellSchool school : focus) {
                        switch (school.getId()) {
                            case "fire": {
                                if (!source.is(DamageTypeTags.IS_FIRE) || !living.fireImmune()) break;
                                flag = flag && (living.isRemoved() || living.isInvulnerable() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !source.isCreativePlayer());
                                break;
                            }
                            case "air": {
                                if (!source.is(DamageTypeTags.IS_FALL) || !living.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) break;
                                flag = flag && (living.isRemoved() || living.isInvulnerable() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !source.isCreativePlayer());
                            }
                        }
                    }
                    if (!flag) {
                        event.setInvulnerable(false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void banglesSpecials(LivingIncomingDamageEvent event) {
        Player player;
        LivingEntity eventTarget = event.getEntity();
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && eventTarget != (player = (Player)entity)) {
            ISummon summon;
            if (eventTarget instanceof ISummon && (summon = (ISummon)eventTarget).getOwnerAlt() == player) {
                return;
            }
            for (SpellSchool bangle : ISchoolBangle.getBangles(event.getEntity().level(), (Entity)player)) {
                if (bangle == null) continue;
                switch (bangle.getId()) {
                    case "fire": {
                        eventTarget.setRemainingFireTicks(100);
                        break;
                    }
                    case "water": {
                        eventTarget.setTicksFrozen(eventTarget.getTicksFrozen() + 100);
                        break;
                    }
                    case "earth": {
                        eventTarget.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SNARE_EFFECT, 60));
                        break;
                    }
                    case "necromancy": {
                        if (player.getRandom().nextBoolean()) {
                            eventTarget.addEffect(new MobEffectInstance(MobEffects.WITHER, 60));
                            break;
                        }
                        eventTarget.heal(1.0f);
                        player.heal(1.0f);
                        break;
                    }
                    case "conjuration": {
                        BlockPos pos = player.blockPosition();
                        player.level().getEntitiesOfClass(LivingEntity.class, new AABB(pos.north(30).west(30).below(10).getCenter(), pos.south(30).east(30).above(10).getCenter()), e -> {
                            ISummon s;
                            return e instanceof ISummon && player.equals((Object)(s = (ISummon)e).getOwnerAlt());
                        }).forEach(e -> {
                            if (e instanceof Monster) {
                                Monster mob = (Monster)e;
                                mob.setTarget(eventTarget);
                            } else if (e instanceof NeutralMob) {
                                NeutralMob neutralMob = (NeutralMob)e;
                                neutralMob.setTarget(eventTarget);
                            }
                            e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 80, 1));
                        });
                    }
                }
            }
        }
        if (eventTarget instanceof Player) {
            player = (Player)eventTarget;
            if ((event.getSource().is(DamageTypes.CACTUS) || event.getSource().is(DamageTypes.SWEET_BERRY_BUSH)) && ISchoolBangle.hasBangle(event.getEntity().level(), (Entity)player, SpellSchools.ELEMENTAL_EARTH)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleHealing(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (((Boolean)ConfigHandler.COMMON.EnableGlyphEmpowering.get()).booleanValue() || (livingEntity = event.getEntity()) instanceof Player && ISchoolFocus.getFociSchools((LivingEntity)(player = (Player)livingEntity)).contains(SpellSchools.ELEMENTAL_EARTH)) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        if (event.getEntity().hasEffect(ModPotions.FROZEN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void damageTweaking(LivingIncomingDamageEvent event) {
        Player player;
        Entity dealer = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (target.hasEffect(ModPotions.FROZEN) && event.getSource().is(ModRegistry.FIRE_DAMAGE)) {
            event.setAmount(event.getAmount() * 1.5f);
            target.removeEffect(ModPotions.FROZEN);
        }
        if (target.hasEffect(ModPotions.MAGIC_FIRE) && event.getSource().is(ModRegistry.EARTH_DAMAGE)) {
            event.setAmount(event.getAmount() * 0.85f);
        }
        if (dealer instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)dealer;
            if (target instanceof Player || target instanceof EntityMageBase) {
                Set<SpellSchool> foci = ISchoolFocus.getFociSchools(caster);
                for (SpellSchool focus : foci) {
                    switch (focus.getId()) {
                        case "water": {
                            if (!(target.getPercentFrozen() > 0.75f) || !event.getSource().is(DamageTypeTags.IS_FREEZING)) break;
                            event.setAmount(event.getAmount() * 1.25f);
                            break;
                        }
                        case "air": {
                            if (!target.hasEffect(MobEffects.LEVITATION) || !event.getSource().is(DamageTypeTags.IS_FALL)) break;
                            event.setAmount(event.getAmount() * 1.25f);
                        }
                    }
                }
            }
        }
        HashMap<SpellSchool, Integer> bonusMap = new HashMap<SpellSchool, Integer>();
        int bonusReduction = 0;
        for (ItemStack stack : event.getEntity().getArmorSlots()) {
            IElementalArmor armor;
            Item item = stack.getItem();
            if (!(item instanceof IElementalArmor) || !(armor = (IElementalArmor)item).fillAbsorptions(event.getSource(), bonusMap)) continue;
            ++bonusReduction;
        }
        boolean not_bypassEnchants = !event.getSource().is(DamageTypeTags.BYPASSES_ENCHANTMENTS);
        Entity armor = event.getSource().getEntity();
        if (armor instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)armor;
            if (target instanceof Player && EnthrallEffect.isEnthralledBy(living, player = (Player)target)) {
                event.setAmount(event.getAmount() * 0.5f);
            }
        }
        if (target instanceof Player || target instanceof EntityMageBase) {
            Set<SpellSchool> schools = ISchoolFocus.getFociSchools(target);
            if (not_bypassEnchants) {
                ManaCap mana;
                if (event.getSource().is(DamageTypes.FLY_INTO_WALL) && schools.contains(SpellSchools.ELEMENTAL_AIR)) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_FIRE, 0) == 4 && event.getSource().is(DamageTypeTags.IS_FIRE)) {
                    target.clearFire();
                    if (schools.contains(SpellSchools.ELEMENTAL_FIRE)) {
                        target.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SPELL_DAMAGE_EFFECT, 200, 2));
                    }
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_WATER, 0) == 4 && event.getSource().is(DamageTypes.DROWN)) {
                    target.setAirSupply(target.getMaxAirSupply());
                    bonusReduction += 5;
                }
                if (target instanceof Player) {
                    player = (Player)target;
                    if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_EARTH, 0) == 4 && target.getEyePosition().y() < 20.0 && player.getFoodData().getFoodLevel() < 4) {
                        player.getFoodData().setFoodLevel(20);
                    }
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_AIR, 0) == 4 && event.getSource().is(DamageTypeTags.IS_FALL)) {
                    bonusReduction += 5;
                }
                if (bonusReduction > 0 && (mana = CapabilityRegistry.getMana((LivingEntity)target)) != null) {
                    if (bonusReduction > 3) {
                        mana.addMana((double)(event.getOriginalAmount() * 5.0f));
                    }
                    event.getEntity().addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT, 200, bonusReduction / 2));
                }
            }
        }
        if (bonusReduction > 0 && not_bypassEnchants) {
            event.setAmount(event.getAmount() * (1.0f - (float)bonusReduction / 10.0f));
        }
        if (event.getSource().is(Tags.DamageTypes.IS_MAGIC) && target.hasEffect(ModPotions.MAGIC_FIRE)) {
            float armorReduction = event.getContainer().getReduction(DamageContainer.Reduction.ARMOR);
            event.setAmount(event.getAmount() + armorReduction * 0.5f);
        }
        LivingEntity living = event.getEntity();
        int ManaBubbleCost = (Integer)EffectBubbleShield.INSTANCE.GENERIC_INT.get() - ManaUtil.getPlayerDiscounts((LivingEntity)living, (Spell)new Spell(new AbstractSpellPart[]{EffectConjureWater.INSTANCE}), (ItemStack)ItemStack.EMPTY);
        MobEffectInstance bubbleEffect = living.getEffect(ModPotions.MANA_BUBBLE);
        if (not_bypassEnchants && bubbleEffect != null) {
            ManaCap mana = CapabilityRegistry.getMana((LivingEntity)living);
            if (mana != null && event.getAmount() < 100000.0f) {
                double maxReduction = mana.getCurrentMana() / (double)ManaBubbleCost;
                double amp = Math.min((double)(1 + bubbleEffect.getAmplifier()), maxReduction);
                float newDamage = (float)Math.max(0.1, (double)event.getAmount() - amp);
                float actualReduction = event.getAmount() - newDamage;
                if (actualReduction > 0.0f && mana.getCurrentMana() >= (double)ManaBubbleCost) {
                    event.setAmount(newDamage);
                    if (event.getContainer().getPostAttackInvulnerabilityTicks() != event.getEntity().invulnerableTime) {
                        mana.removeMana((double)(actualReduction * (float)ManaBubbleCost));
                    }
                }
                if (mana.getCurrentMana() < (double)ManaBubbleCost) {
                    living.removeEffect(ModPotions.MANA_BUBBLE);
                }
            } else if (living instanceof WaterMage) {
                event.setAmount(event.getAmount() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void statusProtect(MobEffectEvent.Applicable event) {
        if (event.getEntity().hasEffect(ModPotions.MANA_BUBBLE)) {
            event.getEffectInstance();
            if (((MobEffect)event.getEffectInstance().getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
                ManaCap mana;
                Optional effects = event.getEntity().level().registryAccess().registryOrThrow(Registries.MOB_EFFECT).getTag(AETagsProvider.AEMobEffectTagProvider.BUBBLE_BLACKLIST);
                if (effects.isPresent() && ((HolderSet.Named)effects.get()).stream().anyMatch(effect -> effect == event.getEffectInstance().getEffect())) {
                    return;
                }
                int ManaBubbleCost = (Integer)EffectBubbleShield.INSTANCE.GENERIC_INT.get() * 2;
                if (event.getEntity().getRandom().nextInt(10) == 0 && (mana = CapabilityRegistry.getMana((LivingEntity)event.getEntity())) != null && mana.getCurrentMana() >= (double)ManaBubbleCost) {
                    mana.removeMana((double)ManaBubbleCost / 2.0);
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
            } else if (event.getEffectInstance().getEffect() == ModPotions.MAGIC_FIRE.getDelegate()) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        }
    }

    @SubscribeEvent
    public static void vorpalCut(SpellDamageEvent.Post event) {
        LivingEntity living;
        Entity entity = event.target;
        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).getHealth() > 0.0f) {
            return;
        }
        if (event.damageSource.is(ModRegistry.CUT)) {
            ItemStack skull = null;
            int chance = 0;
            ResourceLocation mob = RegistryHelper.getRegistryName((EntityType)living.getType());
            if (living instanceof Player) {
                Player player = (Player)living;
                GameProfile gameprofile = player.getGameProfile();
                skull = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                chance = 20;
                skull.set(DataComponents.PROFILE, (Object)new ResolvableProfile(gameprofile));
            } else {
                for (RecipeHolder recipeh : living.level().getRecipeManager().getAllRecipesFor((RecipeType)ModRegistry.HEAD_CUT.get())) {
                    HeadCutRecipe recipe = (HeadCutRecipe)recipeh.value();
                    if (!recipe.mob.equals((Object)mob)) continue;
                    skull = recipe.result.copy();
                    chance = recipe.chance;
                    break;
                }
            }
            if (skull == null) {
                return;
            }
            int looting = Math.min(3, ((DamageUtil.SpellDamageSource)event.damageSource).getLuckLevel());
            for (int i = -1; i < looting; ++i) {
                if (living.getRandom().nextInt(100) > chance) continue;
                living.spawnAtLocation(skull);
                break;
            }
        }
    }
}

