/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.PosCarryMEI;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class RepelEffect
extends MobEffect {
    public RepelEffect() {
        super(MobEffectCategory.NEUTRAL, new ParticleColor(255, 255, 0).getColor());
    }

    public boolean applyEffectTick(LivingEntity entity, int pAmplifier) {
        MobEffectInstance mobEffectInstance = entity.getEffect(ModPotions.REPEL);
        if (!(mobEffectInstance instanceof PosCarryMEI)) {
            return false;
        }
        PosCarryMEI mei = (PosCarryMEI)mobEffectInstance;
        Vec3 dist = new Vec3(entity.getX() - (double)mei.getOrigin().getX(), entity.getY() - (double)mei.getOrigin().getY(), entity.getZ() - (double)mei.getOrigin().getZ());
        if (dist.length() < 15.0) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(dist.normalize()).scale(0.5));
            entity.hurtMarked = true;
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

