/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.entity.MermaidEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;

public class MermaidAi {
    private static final float SPEED_MULTIPLIER_ON_LAND = 0.15f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING_IN_WATER = 0.5f;
    private static final float SPEED_MULTIPLIER_WHEN_CHASING_IN_WATER = 0.6f;

    public static Brain<?> makeBrain(Brain<MermaidEntity> p_149291_) {
        MermaidAi.initCoreActivity(p_149291_);
        MermaidAi.initIdleActivity(p_149291_);
        p_149291_.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        p_149291_.setDefaultActivity(Activity.IDLE);
        p_149291_.useDefaultActivity();
        return p_149291_;
    }

    private static void initCoreActivity(Brain<MermaidEntity> p_149307_) {
        p_149307_.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<MermaidEntity> p_149309_) {
        p_149309_.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)StartAttacking.create(MermaidAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)TryFindWater.create((int)6, (float)0.15f)), (Object)Pair.of((Object)4, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)0.5f), (Object)2), (Object)Pair.of((Object)RandomStroll.stroll((float)0.15f, (boolean)false), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create(MermaidAi::canSetWalkTargetFromLookTarget, MermaidAi::getSpeedModifier, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWaterOrBubble), (Object)5), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::onGround), (Object)5))))));
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity p_182381_) {
        Level level = p_182381_.level;
        Optional optional = p_182381_.getBrain().getMemory(MemoryModuleType.LOOK_TARGET);
        if (optional.isPresent()) {
            BlockPos blockpos = ((PositionTracker)optional.get()).currentBlockPosition();
            return level.isWaterAt(blockpos) == p_182381_.isInWaterOrBubble();
        }
        return false;
    }

    public static void updateActivity(MermaidEntity p_149293_) {
        Brain<MermaidEntity> brain = p_149293_.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        if (activity == Activity.FIGHT && brain.getActiveNonCoreActivity().orElse(null) != Activity.FIGHT) {
            brain.setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, 2400L);
        }
    }

    private static float getSpeedModifierChasing(LivingEntity p_149289_) {
        return p_149289_.isInWaterOrBubble() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(LivingEntity p_149301_) {
        return p_149301_.isInWaterOrBubble() ? 0.5f : 0.15f;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(MermaidEntity p_149299_) {
        return p_149299_.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }
}

